@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.GetUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUsers.
 * @property displayName Specify the New Created the User's Display Name. Supports up to 128 Characters.
 * @property ids A list of User IDs.
 * @property instanceId You Want to Query the User the Bastion Host ID of.
 * @property mobile Specify the New of the User That Created a Different Mobile Phone Number from Your.
 * @property nameRegex A regex string to filter results by User name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property source Specify the New of the User That Created the Source. Valid Values: Local: Local User RAM: Ram User. Valid values: `Local`, `Ram`.
 * @property sourceUserId Specify the Newly Created User Is Uniquely Identified. Indicates That the Parameter Is a Bastion Host Corresponding to the User with the Ram User's Unique Identifier. The Newly Created User Source Grant Permission to a RAM User (That Is, Source Used as a Ram), this Parameter Is Required. You Can Call Access Control of Listusers Interface from the Return Data Userid to Obtain the Parameters.
 * @property status The status of the resource. Valid values: `Frozen`, `Normal`.
 * @property userName Specify the New User Name. This Parameter Is Only by Letters, Lowercase Letters, Numbers, and Underscores (_), Supports up to 128 Characters.
 */
public data class GetUsersPlainArgs(
    public val displayName: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val mobile: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val source: String? = null,
    public val sourceUserId: String? = null,
    public val status: String? = null,
    public val userName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.GetUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.GetUsersPlainArgs =
        com.pulumi.alicloud.bastionhost.inputs.GetUsersPlainArgs.builder()
            .displayName(displayName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .mobile(mobile?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .source(source?.let({ args0 -> args0 }))
            .sourceUserId(sourceUserId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .userName(userName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUsersPlainArgs].
 */
@PulumiTagMarker
public class GetUsersPlainArgsBuilder internal constructor() {
    private var displayName: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var mobile: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var source: String? = null

    private var sourceUserId: String? = null

    private var status: String? = null

    private var userName: String? = null

    /**
     * @param value Specify the New Created the User's Display Name. Supports up to 128 Characters.
     */
    @JvmName("ftnjkdrocxibwqkb")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.displayName = mapped
    }

    /**
     * @param value A list of User IDs.
     */
    @JvmName("wuhldbhsetjfqiew")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of User IDs.
     */
    @JvmName("jbtwfqotpmkvbsdi")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value You Want to Query the User the Bastion Host ID of.
     */
    @JvmName("ygnvgpfmetbqnddp")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Specify the New of the User That Created a Different Mobile Phone Number from Your.
     */
    @JvmName("ghkpjptjemvukssq")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mobile = mapped
    }

    /**
     * @param value A regex string to filter results by User name.
     */
    @JvmName("scpqypehctbrndas")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bqsowwwfbbsetlgg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Specify the New of the User That Created the Source. Valid Values: Local: Local User RAM: Ram User. Valid values: `Local`, `Ram`.
     */
    @JvmName("gnavjhayybnddurx")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.source = mapped
    }

    /**
     * @param value Specify the Newly Created User Is Uniquely Identified. Indicates That the Parameter Is a Bastion Host Corresponding to the User with the Ram User's Unique Identifier. The Newly Created User Source Grant Permission to a RAM User (That Is, Source Used as a Ram), this Parameter Is Required. You Can Call Access Control of Listusers Interface from the Return Data Userid to Obtain the Parameters.
     */
    @JvmName("lwmkxlueujbhxlev")
    public suspend fun sourceUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceUserId = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `Frozen`, `Normal`.
     */
    @JvmName("cvujshwrsoxfmrit")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Specify the New User Name. This Parameter Is Only by Letters, Lowercase Letters, Numbers, and Underscores (_), Supports up to 128 Characters.
     */
    @JvmName("lnwjtqdhsvitteem")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetUsersPlainArgs = GetUsersPlainArgs(
        displayName = displayName,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        mobile = mobile,
        nameRegex = nameRegex,
        outputFile = outputFile,
        source = source,
        sourceUserId = sourceUserId,
        status = status,
        userName = userName,
    )
}
