@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.InstanceAdAuthServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property account The username of the account that is used for the AD server.
 * @property baseDn The Base distinguished name (DN).
 * @property domain The domain on the AD server.
 * @property emailMapping The field that is used to indicate the email address of a user on the AD server.
 * @property filter The condition that is used to filter users.
 * @property isSsl Specifies whether to support SSL.
 * @property mobileMapping The field that is used to indicate the mobile phone number of a user on the AD server.
 * @property nameMapping The field that is used to indicate the name of a user on the AD server.
 * @property password The password of the account that is used for the AD server.
 * @property port The port that is used to access the AD server.
 * @property server The address of the AD server.
 * @property standbyServer The address of the secondary AD server.
 */
public data class InstanceAdAuthServerArgs(
    public val account: Output<String>,
    public val baseDn: Output<String>,
    public val domain: Output<String>,
    public val emailMapping: Output<String>? = null,
    public val filter: Output<String>? = null,
    public val isSsl: Output<Boolean>,
    public val mobileMapping: Output<String>? = null,
    public val nameMapping: Output<String>? = null,
    public val password: Output<String>,
    public val port: Output<Int>,
    public val server: Output<String>,
    public val standbyServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.InstanceAdAuthServerArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.InstanceAdAuthServerArgs =
        com.pulumi.alicloud.bastionhost.inputs.InstanceAdAuthServerArgs.builder()
            .account(account.applyValue({ args0 -> args0 }))
            .baseDn(baseDn.applyValue({ args0 -> args0 }))
            .domain(domain.applyValue({ args0 -> args0 }))
            .emailMapping(emailMapping?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0 }))
            .isSsl(isSsl.applyValue({ args0 -> args0 }))
            .mobileMapping(mobileMapping?.applyValue({ args0 -> args0 }))
            .nameMapping(nameMapping?.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .standbyServer(standbyServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAdAuthServerArgs].
 */
@PulumiTagMarker
public class InstanceAdAuthServerArgsBuilder internal constructor() {
    private var account: Output<String>? = null

    private var baseDn: Output<String>? = null

    private var domain: Output<String>? = null

    private var emailMapping: Output<String>? = null

    private var filter: Output<String>? = null

    private var isSsl: Output<Boolean>? = null

    private var mobileMapping: Output<String>? = null

    private var nameMapping: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var server: Output<String>? = null

    private var standbyServer: Output<String>? = null

    /**
     * @param value The username of the account that is used for the AD server.
     */
    @JvmName("jvnusfdhphdyjnkq")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value The Base distinguished name (DN).
     */
    @JvmName("uqttneplryiyrxjt")
    public suspend fun baseDn(`value`: Output<String>) {
        this.baseDn = value
    }

    /**
     * @param value The domain on the AD server.
     */
    @JvmName("rkaubecgnrmyvqjy")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The field that is used to indicate the email address of a user on the AD server.
     */
    @JvmName("vmrgffugdgxamsbf")
    public suspend fun emailMapping(`value`: Output<String>) {
        this.emailMapping = value
    }

    /**
     * @param value The condition that is used to filter users.
     */
    @JvmName("cwdieirqybevdkya")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value Specifies whether to support SSL.
     */
    @JvmName("akhedjejcpqdstga")
    public suspend fun isSsl(`value`: Output<Boolean>) {
        this.isSsl = value
    }

    /**
     * @param value The field that is used to indicate the mobile phone number of a user on the AD server.
     */
    @JvmName("cqtedqfalglkvols")
    public suspend fun mobileMapping(`value`: Output<String>) {
        this.mobileMapping = value
    }

    /**
     * @param value The field that is used to indicate the name of a user on the AD server.
     */
    @JvmName("gqbtedhlamtemjmo")
    public suspend fun nameMapping(`value`: Output<String>) {
        this.nameMapping = value
    }

    /**
     * @param value The password of the account that is used for the AD server.
     */
    @JvmName("ojjfycuwltqpexkm")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The port that is used to access the AD server.
     */
    @JvmName("tfosgualwsllidri")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The address of the AD server.
     */
    @JvmName("migxiwhcjlfbtfws")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The address of the secondary AD server.
     */
    @JvmName("imgvimmxxmddsdho")
    public suspend fun standbyServer(`value`: Output<String>) {
        this.standbyServer = value
    }

    /**
     * @param value The username of the account that is used for the AD server.
     */
    @JvmName("cibeiesjabnrrneb")
    public suspend fun account(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value The Base distinguished name (DN).
     */
    @JvmName("awxtojoyjnpuiffm")
    public suspend fun baseDn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseDn = mapped
    }

    /**
     * @param value The domain on the AD server.
     */
    @JvmName("rtpcbldtclxjenlh")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The field that is used to indicate the email address of a user on the AD server.
     */
    @JvmName("btedwutmakywmxlv")
    public suspend fun emailMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMapping = mapped
    }

    /**
     * @param value The condition that is used to filter users.
     */
    @JvmName("becrsxktlljwyrdk")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value Specifies whether to support SSL.
     */
    @JvmName("yenegehewxnntfdg")
    public suspend fun isSsl(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isSsl = mapped
    }

    /**
     * @param value The field that is used to indicate the mobile phone number of a user on the AD server.
     */
    @JvmName("cvwxnjyycnetexsn")
    public suspend fun mobileMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileMapping = mapped
    }

    /**
     * @param value The field that is used to indicate the name of a user on the AD server.
     */
    @JvmName("wgwkxjppsgirwttt")
    public suspend fun nameMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameMapping = mapped
    }

    /**
     * @param value The password of the account that is used for the AD server.
     */
    @JvmName("nabgjmdgnwwrwlqu")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The port that is used to access the AD server.
     */
    @JvmName("ikrdqabdedbulvfy")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The address of the AD server.
     */
    @JvmName("alvlnnmiddbincug")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The address of the secondary AD server.
     */
    @JvmName("tjehxvgcurwpnctv")
    public suspend fun standbyServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyServer = mapped
    }

    internal fun build(): InstanceAdAuthServerArgs = InstanceAdAuthServerArgs(
        account = account ?: throw PulumiNullFieldException("account"),
        baseDn = baseDn ?: throw PulumiNullFieldException("baseDn"),
        domain = domain ?: throw PulumiNullFieldException("domain"),
        emailMapping = emailMapping,
        filter = filter,
        isSsl = isSsl ?: throw PulumiNullFieldException("isSsl"),
        mobileMapping = mobileMapping,
        nameMapping = nameMapping,
        password = password ?: throw PulumiNullFieldException("password"),
        port = port ?: throw PulumiNullFieldException("port"),
        server = server ?: throw PulumiNullFieldException("server"),
        standbyServer = standbyServer,
    )
}
