@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.inputs

import com.pulumi.alicloud.bastionhost.inputs.InstanceLdapAuthServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property account The username of the account that is used for the LDAP server.
 * @property baseDn The Base distinguished name (DN).
 * @property emailMapping The field that is used to indicate the email address of a user on the LDAP server.
 * @property filter The condition that is used to filter users.
 * @property isSsl Specifies whether to support SSL.
 * @property loginNameMapping The field that is used to indicate the logon name of a user on the LDAP server.
 * @property mobileMapping The field that is used to indicate the mobile phone number of a user on the LDAP server.
 * @property nameMapping The field that is used to indicate the name of a user on the LDAP server.
 * @property password The password of the account that is used for the LDAP server.
 * @property port The port that is used to access the LDAP server.
 * @property server The address of the LDAP server.
 * @property standbyServer The address of the secondary LDAP server.
 */
public data class InstanceLdapAuthServerArgs(
    public val account: Output<String>,
    public val baseDn: Output<String>,
    public val emailMapping: Output<String>? = null,
    public val filter: Output<String>? = null,
    public val isSsl: Output<Boolean>? = null,
    public val loginNameMapping: Output<String>? = null,
    public val mobileMapping: Output<String>? = null,
    public val nameMapping: Output<String>? = null,
    public val password: Output<String>,
    public val port: Output<Int>,
    public val server: Output<String>,
    public val standbyServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bastionhost.inputs.InstanceLdapAuthServerArgs> {
    override fun toJava(): com.pulumi.alicloud.bastionhost.inputs.InstanceLdapAuthServerArgs =
        com.pulumi.alicloud.bastionhost.inputs.InstanceLdapAuthServerArgs.builder()
            .account(account.applyValue({ args0 -> args0 }))
            .baseDn(baseDn.applyValue({ args0 -> args0 }))
            .emailMapping(emailMapping?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0 }))
            .isSsl(isSsl?.applyValue({ args0 -> args0 }))
            .loginNameMapping(loginNameMapping?.applyValue({ args0 -> args0 }))
            .mobileMapping(mobileMapping?.applyValue({ args0 -> args0 }))
            .nameMapping(nameMapping?.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .standbyServer(standbyServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceLdapAuthServerArgs].
 */
@PulumiTagMarker
public class InstanceLdapAuthServerArgsBuilder internal constructor() {
    private var account: Output<String>? = null

    private var baseDn: Output<String>? = null

    private var emailMapping: Output<String>? = null

    private var filter: Output<String>? = null

    private var isSsl: Output<Boolean>? = null

    private var loginNameMapping: Output<String>? = null

    private var mobileMapping: Output<String>? = null

    private var nameMapping: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var server: Output<String>? = null

    private var standbyServer: Output<String>? = null

    /**
     * @param value The username of the account that is used for the LDAP server.
     */
    @JvmName("ubakyibmvrncuynh")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value The Base distinguished name (DN).
     */
    @JvmName("bimdrfssbjahlsti")
    public suspend fun baseDn(`value`: Output<String>) {
        this.baseDn = value
    }

    /**
     * @param value The field that is used to indicate the email address of a user on the LDAP server.
     */
    @JvmName("pwiujoigbhduyciq")
    public suspend fun emailMapping(`value`: Output<String>) {
        this.emailMapping = value
    }

    /**
     * @param value The condition that is used to filter users.
     */
    @JvmName("icpgvtkcmtttvufj")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value Specifies whether to support SSL.
     */
    @JvmName("utoylsxppdkixkoq")
    public suspend fun isSsl(`value`: Output<Boolean>) {
        this.isSsl = value
    }

    /**
     * @param value The field that is used to indicate the logon name of a user on the LDAP server.
     */
    @JvmName("oqiqecmdvogtckod")
    public suspend fun loginNameMapping(`value`: Output<String>) {
        this.loginNameMapping = value
    }

    /**
     * @param value The field that is used to indicate the mobile phone number of a user on the LDAP server.
     */
    @JvmName("yyifouvglwbfvkqc")
    public suspend fun mobileMapping(`value`: Output<String>) {
        this.mobileMapping = value
    }

    /**
     * @param value The field that is used to indicate the name of a user on the LDAP server.
     */
    @JvmName("vqaestnahmmhkebk")
    public suspend fun nameMapping(`value`: Output<String>) {
        this.nameMapping = value
    }

    /**
     * @param value The password of the account that is used for the LDAP server.
     */
    @JvmName("wmqeadehxvjepmep")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The port that is used to access the LDAP server.
     */
    @JvmName("tdpmarawdkjjiget")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The address of the LDAP server.
     */
    @JvmName("mhgupqrmsadkoath")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The address of the secondary LDAP server.
     */
    @JvmName("xwgajrvebkwcsahc")
    public suspend fun standbyServer(`value`: Output<String>) {
        this.standbyServer = value
    }

    /**
     * @param value The username of the account that is used for the LDAP server.
     */
    @JvmName("tikhtxyndycjteqj")
    public suspend fun account(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value The Base distinguished name (DN).
     */
    @JvmName("sfcomglvtehhdktf")
    public suspend fun baseDn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseDn = mapped
    }

    /**
     * @param value The field that is used to indicate the email address of a user on the LDAP server.
     */
    @JvmName("logqnqdtliukpwbe")
    public suspend fun emailMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMapping = mapped
    }

    /**
     * @param value The condition that is used to filter users.
     */
    @JvmName("kseclfabmwwegodx")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value Specifies whether to support SSL.
     */
    @JvmName("ahcvxxsmnxohsdeb")
    public suspend fun isSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSsl = mapped
    }

    /**
     * @param value The field that is used to indicate the logon name of a user on the LDAP server.
     */
    @JvmName("vxspkntbvjyrheek")
    public suspend fun loginNameMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginNameMapping = mapped
    }

    /**
     * @param value The field that is used to indicate the mobile phone number of a user on the LDAP server.
     */
    @JvmName("nempkjlpqvcxekog")
    public suspend fun mobileMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileMapping = mapped
    }

    /**
     * @param value The field that is used to indicate the name of a user on the LDAP server.
     */
    @JvmName("fuleerlpwjapcgxb")
    public suspend fun nameMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameMapping = mapped
    }

    /**
     * @param value The password of the account that is used for the LDAP server.
     */
    @JvmName("lavpicxlwvjpnpds")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The port that is used to access the LDAP server.
     */
    @JvmName("kkqgheopljoqghnv")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The address of the LDAP server.
     */
    @JvmName("prkfxhlwbvmuhyog")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The address of the secondary LDAP server.
     */
    @JvmName("bfiwypggodmaoyqp")
    public suspend fun standbyServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyServer = mapped
    }

    internal fun build(): InstanceLdapAuthServerArgs = InstanceLdapAuthServerArgs(
        account = account ?: throw PulumiNullFieldException("account"),
        baseDn = baseDn ?: throw PulumiNullFieldException("baseDn"),
        emailMapping = emailMapping,
        filter = filter,
        isSsl = isSsl,
        loginNameMapping = loginNameMapping,
        mobileMapping = mobileMapping,
        nameMapping = nameMapping,
        password = password ?: throw PulumiNullFieldException("password"),
        port = port ?: throw PulumiNullFieldException("port"),
        server = server ?: throw PulumiNullFieldException("server"),
        standbyServer = standbyServer,
    )
}
