@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hasPassword Whether to set a new password.
 * @property hostAccountId Hosting account ID.
 * @property hostAccountName Specify the new hosting account's name, support the longest 128 characters.
 * @property hostId Specifies the database where you want to create your hosting account's host ID.
 * @property id The ID of the Host Account.
 * @property instanceId Specifies the database where you want to create your hosting account's host bastion host ID of.
 * @property privateKeyFingerprint The situation where the private keys of the fingerprint information.
 * @property protocolName Specify the new hosting account of the agreement name. Valid values: USING SSH and RDP.
 */
public data class GetHostAccountsAccount(
    public val hasPassword: Boolean,
    public val hostAccountId: String,
    public val hostAccountName: String,
    public val hostId: String,
    public val id: String,
    public val instanceId: String,
    public val privateKeyFingerprint: String,
    public val protocolName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetHostAccountsAccount): GetHostAccountsAccount = GetHostAccountsAccount(
            hasPassword = javaType.hasPassword(),
            hostAccountId = javaType.hostAccountId(),
            hostAccountName = javaType.hostAccountName(),
            hostId = javaType.hostId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            privateKeyFingerprint = javaType.privateKeyFingerprint(),
            protocolName = javaType.protocolName(),
        )
    }
}
