@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHostAccounts.
 * @property accounts
 * @property hostAccountName
 * @property hostId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property protocolName
 */
public data class GetHostAccountsResult(
    public val accounts: List<GetHostAccountsAccount>,
    public val hostAccountName: String? = null,
    public val hostId: String,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val protocolName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetHostAccountsResult): GetHostAccountsResult = GetHostAccountsResult(
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostAccountsAccount.Companion.toKotlin(args0)
                })
            }),
            hostAccountName = javaType.hostAccountName().map({ args0 -> args0 }).orElse(null),
            hostId = javaType.hostId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            protocolName = javaType.protocolName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
