@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment Specify the New Host Group of Notes, Supports up to 500 Characters.
 * @property hostGroupId Host Group ID.
 * @property hostGroupName Specify the New Host Group Name, Supports up to 128 Characters.
 * @property id The ID of the Host Group.
 * @property instanceId Specify the New Host Group Where the Bastion Host ID of.
 */
public data class GetHostGroupsGroup(
    public val comment: String,
    public val hostGroupId: String,
    public val hostGroupName: String,
    public val id: String,
    public val instanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetHostGroupsGroup): GetHostGroupsGroup = GetHostGroupsGroup(
            comment = javaType.comment(),
            hostGroupId = javaType.hostGroupId(),
            hostGroupName = javaType.hostGroupName(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
        )
    }
}
