@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hostShareKeyId The first ID of the resource.
 * @property hostShareKeyName The name of the host shared key.
 * @property id The ID of the Host Share Key.
 * @property instanceId The ID of the Bastion instance.
 * @property privateKeyFingerPrint The fingerprint of the private key.
 */
public data class GetHostShareKeysKey(
    public val hostShareKeyId: String,
    public val hostShareKeyName: String,
    public val id: String,
    public val instanceId: String,
    public val privateKeyFingerPrint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetHostShareKeysKey): GetHostShareKeysKey = GetHostShareKeysKey(
            hostShareKeyId = javaType.hostShareKeyId(),
            hostShareKeyName = javaType.hostShareKeyName(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            privateKeyFingerPrint = javaType.privateKeyFingerPrint(),
        )
    }
}
