@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property activeAddressType Specify the new create a host of address types. Valid values: Public: the IP address of a Public network Private: Private network address.
 * @property comment Specify a host of notes, supports up to 500 characters.
 * @property hostId The host ID.
 * @property hostName Specify the new create a host name of the supports up to 128 characters.
 * @property hostPrivateAddress Specify the new create a host of the private network address, it is possible to use the domain name or IP ADDRESS.
 * @property hostPublicAddress Specify the new create a host of the IP address of a public network, it is possible to use the domain name or IP ADDRESS.
 * @property id The ID of the Host.
 * @property instanceId Specify the new create a host where the Bastion host ID of.
 * @property osType Specify the new create the host's operating system. Valid values: Linux Windows.
 * @property protocols The host of the protocol information.
 * @property source Specify the new create a host of source. Valid values: Local: localhost Ecs:ECS instance Rds:RDS exclusive cluster host.
 * @property sourceInstanceId Specify the newly created ECS instance ID or dedicated cluster host ID.
 */
public data class GetHostsHost(
    public val activeAddressType: String,
    public val comment: String,
    public val hostId: String,
    public val hostName: String,
    public val hostPrivateAddress: String,
    public val hostPublicAddress: String,
    public val id: String,
    public val instanceId: String,
    public val osType: String,
    public val protocols: List<GetHostsHostProtocol>,
    public val source: String,
    public val sourceInstanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetHostsHost): GetHostsHost = GetHostsHost(
            activeAddressType = javaType.activeAddressType(),
            comment = javaType.comment(),
            hostId = javaType.hostId(),
            hostName = javaType.hostName(),
            hostPrivateAddress = javaType.hostPrivateAddress(),
            hostPublicAddress = javaType.hostPublicAddress(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            osType = javaType.osType(),
            protocols = javaType.protocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostsHostProtocol.Companion.toKotlin(args0)
                })
            }),
            source = javaType.source(),
            sourceInstanceId = javaType.sourceInstanceId(),
        )
    }
}
