@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHosts.
 * @property enableDetails
 * @property hostAddress
 * @property hostName
 * @property hosts
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property osType
 * @property outputFile
 * @property source
 * @property sourceInstanceId
 * @property sourceInstanceState
 */
public data class GetHostsResult(
    public val enableDetails: Boolean? = null,
    public val hostAddress: String? = null,
    public val hostName: String? = null,
    public val hosts: List<GetHostsHost>,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val osType: String? = null,
    public val outputFile: String? = null,
    public val source: String? = null,
    public val sourceInstanceId: String? = null,
    public val sourceInstanceState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetHostsResult): GetHostsResult = GetHostsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            hostAddress = javaType.hostAddress().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            hosts = javaType.hosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bastionhost.kotlin.outputs.GetHostsHost.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            sourceInstanceId = javaType.sourceInstanceId().map({ args0 -> args0 }).orElse(null),
            sourceInstanceState = javaType.sourceInstanceState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
