@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property description The instance's remark.
 * @property id The instance's id.
 * @property instanceStatus The instance's status.
 * @property licenseCode
 * @property privateDomain The instance's private domain name.
 * @property publicDomain The instance's public domain name.
 * @property publicNetworkAccess The instance's public network access configuration.
 * @property securityGroupIds The instance's security group configuration.
 * @property tags A map of tags assigned to the bastionhost instance. It must be in the format:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const instance = alicloud.bastionhost.getInstances({
 *     tags: {
 *         tagKey1: "tagValue1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * instance = alicloud.bastionhost.get_instances(tags={
 *     "tagKey1": "tagValue1",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = AliCloud.BastionHost.GetInstances.Invoke(new()
 *     {
 *         Tags =
 *         {
 *             { "tagKey1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bastionhost"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := bastionhost.GetInstances(ctx, &bastionhost.GetInstancesArgs{
 * 			Tags: map[string]interface{}{
 * 				"tagKey1": "tagValue1",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.bastionhost.BastionhostFunctions;
 * import com.pulumi.alicloud.bastionhost.inputs.GetInstancesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var instance = BastionhostFunctions.getInstances(GetInstancesArgs.builder()
 *             .tags(Map.of("tagKey1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   instance:
 *     fn::invoke:
 *       Function: alicloud:bastionhost:getInstances
 *       Arguments:
 *         tags:
 *           tagKey1: tagValue1
 * ```
 * <!--End PulumiCodeChooser -->
 * @property userVswitchId The instance's vSwitch ID.
 */
public data class GetInstancesInstance(
    public val description: String,
    public val id: String,
    public val instanceStatus: String,
    public val licenseCode: String,
    public val privateDomain: String,
    public val publicDomain: String,
    public val publicNetworkAccess: Boolean,
    public val securityGroupIds: List<String>,
    public val tags: Map<String, String>? = null,
    public val userVswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            description = javaType.description(),
            id = javaType.id(),
            instanceStatus = javaType.instanceStatus(),
            licenseCode = javaType.licenseCode(),
            privateDomain = javaType.privateDomain(),
            publicDomain = javaType.publicDomain(),
            publicNetworkAccess = javaType.publicNetworkAccess(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userVswitchId = javaType.userVswitchId(),
        )
    }
}
