@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property descriptionRegex
 * @property descriptions
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instances A list of apis. Each element contains the following attributes:
 * @property outputFile
 * @property tags A map of tags assigned to the bastionhost instance.
 */
public data class GetInstancesResult(
    public val descriptionRegex: String? = null,
    public val descriptions: List<String>,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetInstancesInstance>,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            descriptions = javaType.descriptions().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bastionhost.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
