@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment Specify the New Group of Remark Information. Supports up to 500 Characters.
 * @property id The ID of the User Group.
 * @property instanceId Specify the New Group of the Bastion Host of Instance Id.
 * @property userGroupId The User Group ID.
 * @property userGroupName Specify the New Group Name. Supports up to 128 Characters.
 */
public data class GetUserGroupsGroup(
    public val comment: String,
    public val id: String,
    public val instanceId: String,
    public val userGroupId: String,
    public val userGroupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetUserGroupsGroup): GetUserGroupsGroup = GetUserGroupsGroup(
            comment = javaType.comment(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            userGroupId = javaType.userGroupId(),
            userGroupName = javaType.userGroupName(),
        )
    }
}
