@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUsers.
 * @property displayName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property mobile
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property source
 * @property sourceUserId
 * @property status
 * @property userName
 * @property users
 */
public data class GetUsersResult(
    public val displayName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val mobile: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val source: String? = null,
    public val sourceUserId: String? = null,
    public val status: String? = null,
    public val userName: String? = null,
    public val users: List<GetUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetUsersResult): GetUsersResult = GetUsersResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            mobile = javaType.mobile().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            sourceUserId = javaType.sourceUserId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bastionhost.kotlin.outputs.GetUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
