@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment Specify the New of the User That Created the Remark Information. Supports up to 500 Characters.
 * @property displayName Specify the New Created the User's Display Name. Supports up to 128 Characters.
 * @property email Specify the New User's Mailbox.
 * @property id The ID of the User.
 * @property instanceId You Want to Query the User the Bastion Host ID of.
 * @property mobile Specify the New of the User That Created a Different Mobile Phone Number from Your.
 * @property mobileCountryCode Specify the New Create User Mobile Phone Number of the International Domain Name. The Default Value Is the CN Value: CN: Mainland China (+86) HK: hong Kong, China (+852) Mo: Macau, China (+853) TW: Taiwan, China (+886) ru: Russian (+7) SG: Singapore (+65) My: malaysia (+60) ID: Indonesia (+62) De: Germany (+49) AU: Australia (+61) US: United States (+1) AE: dubai (+971) JP: Japan (+81) Introducing the Long-Range GB: United Kingdom (+44) in: India (+91) KR: South Korea (+82) Ph: philippines (+63) Ch: Switzerland (+41) Se: Sweden (+46).
 * @property source Specify the New of the User That Created the Source. Valid Values: Local: Local User RAM: Ram User.
 * @property sourceUserId Specify the Newly Created User Is Uniquely Identified. Indicates That the Parameter Is a Bastion Host Corresponding to the User with the Ram User's Unique Identifier. The Newly Created User Source Grant Permission to a RAM User (That Is, Source Used as a Ram), this Parameter Is Required. You Can Call Access Control of Listusers Interface from the Return Data Userid to Obtain the Parameters.
 * @property status The status of the resource.
 * @property userId The User ID.
 * @property userName Specify the New User Name. This Parameter Is Only by Letters, Lowercase Letters, Numbers, and Underscores (_), Supports up to 128 Characters.
 */
public data class GetUsersUser(
    public val comment: String,
    public val displayName: String,
    public val email: String,
    public val id: String,
    public val instanceId: String,
    public val mobile: String,
    public val mobileCountryCode: String,
    public val source: String,
    public val sourceUserId: String,
    public val status: String,
    public val userId: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.GetUsersUser): GetUsersUser = GetUsersUser(
            comment = javaType.comment(),
            displayName = javaType.displayName(),
            email = javaType.email(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            mobile = javaType.mobile(),
            mobileCountryCode = javaType.mobileCountryCode(),
            source = javaType.source(),
            sourceUserId = javaType.sourceUserId(),
            status = javaType.status(),
            userId = javaType.userId(),
            userName = javaType.userName(),
        )
    }
}
