@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property account The username of the account that is used for the AD server.
 * @property baseDn The Base distinguished name (DN).
 * @property domain The domain on the AD server.
 * @property emailMapping The field that is used to indicate the email address of a user on the AD server.
 * @property filter The condition that is used to filter users.
 * @property isSsl Specifies whether to support SSL.
 * @property mobileMapping The field that is used to indicate the mobile phone number of a user on the AD server.
 * @property nameMapping The field that is used to indicate the name of a user on the AD server.
 * @property password The password of the account that is used for the AD server.
 * @property port The port that is used to access the AD server.
 * @property server The address of the AD server.
 * @property standbyServer The address of the secondary AD server.
 */
public data class InstanceAdAuthServer(
    public val account: String,
    public val baseDn: String,
    public val domain: String,
    public val emailMapping: String? = null,
    public val filter: String? = null,
    public val isSsl: Boolean,
    public val mobileMapping: String? = null,
    public val nameMapping: String? = null,
    public val password: String,
    public val port: Int,
    public val server: String,
    public val standbyServer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.InstanceAdAuthServer): InstanceAdAuthServer = InstanceAdAuthServer(
            account = javaType.account(),
            baseDn = javaType.baseDn(),
            domain = javaType.domain(),
            emailMapping = javaType.emailMapping().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 -> args0 }).orElse(null),
            isSsl = javaType.isSsl(),
            mobileMapping = javaType.mobileMapping().map({ args0 -> args0 }).orElse(null),
            nameMapping = javaType.nameMapping().map({ args0 -> args0 }).orElse(null),
            password = javaType.password(),
            port = javaType.port(),
            server = javaType.server(),
            standbyServer = javaType.standbyServer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
