@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bastionhost.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property account The username of the account that is used for the LDAP server.
 * @property baseDn The Base distinguished name (DN).
 * @property emailMapping The field that is used to indicate the email address of a user on the LDAP server.
 * @property filter The condition that is used to filter users.
 * @property isSsl Specifies whether to support SSL.
 * @property loginNameMapping The field that is used to indicate the logon name of a user on the LDAP server.
 * @property mobileMapping The field that is used to indicate the mobile phone number of a user on the LDAP server.
 * @property nameMapping The field that is used to indicate the name of a user on the LDAP server.
 * @property password The password of the account that is used for the LDAP server.
 * @property port The port that is used to access the LDAP server.
 * @property server The address of the LDAP server.
 * @property standbyServer The address of the secondary LDAP server.
 */
public data class InstanceLdapAuthServer(
    public val account: String,
    public val baseDn: String,
    public val emailMapping: String? = null,
    public val filter: String? = null,
    public val isSsl: Boolean? = null,
    public val loginNameMapping: String? = null,
    public val mobileMapping: String? = null,
    public val nameMapping: String? = null,
    public val password: String,
    public val port: Int,
    public val server: String,
    public val standbyServer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bastionhost.outputs.InstanceLdapAuthServer): InstanceLdapAuthServer = InstanceLdapAuthServer(
            account = javaType.account(),
            baseDn = javaType.baseDn(),
            emailMapping = javaType.emailMapping().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 -> args0 }).orElse(null),
            isSsl = javaType.isSsl().map({ args0 -> args0 }).orElse(null),
            loginNameMapping = javaType.loginNameMapping().map({ args0 -> args0 }).orElse(null),
            mobileMapping = javaType.mobileMapping().map({ args0 -> args0 }).orElse(null),
            nameMapping = javaType.nameMapping().map({ args0 -> args0 }).orElse(null),
            password = javaType.password(),
            port = javaType.port(),
            server = javaType.server(),
            standbyServer = javaType.standbyServer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
