@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin

import com.pulumi.alicloud.bp.BpFunctions.getStudioApplicationsPlain
import com.pulumi.alicloud.bp.kotlin.inputs.GetStudioApplicationsPlainArgs
import com.pulumi.alicloud.bp.kotlin.inputs.GetStudioApplicationsPlainArgsBuilder
import com.pulumi.alicloud.bp.kotlin.outputs.GetStudioApplicationsResult
import com.pulumi.alicloud.bp.kotlin.outputs.GetStudioApplicationsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object BpFunctions {
    /**
     * This data source provides the Cloud Architect Design Tools (BPStudio) Applications of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.192.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.bp.getStudioApplications({
     *     ids: ["example_id"],
     * });
     * export const bpStudioApplicationId1 = ids.then(ids => ids.applications?.[0]?.id);
     * const nameRegex = alicloud.bp.getStudioApplications({
     *     nameRegex: "^my-Application",
     * });
     * export const bpStudioApplicationId2 = nameRegex.then(nameRegex => nameRegex.applications?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.bp.get_studio_applications(ids=["example_id"])
     * pulumi.export("bpStudioApplicationId1", ids.applications[0].id)
     * name_regex = alicloud.bp.get_studio_applications(name_regex="^my-Application")
     * pulumi.export("bpStudioApplicationId2", name_regex.applications[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Bp.GetStudioApplications.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Bp.GetStudioApplications.Invoke(new()
     *     {
     *         NameRegex = "^my-Application",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["bpStudioApplicationId1"] = ids&#46;Apply(getStudioApplicationsResult => getStudioApplicationsResult&#46;Applications[0]?.Id),
     *         ["bpStudioApplicationId2"] = nameRegex&#46;Apply(getStudioApplicationsResult => getStudioApplicationsResult&#46;Applications[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := bp.GetStudioApplications(ctx, &bp.GetStudioApplicationsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bpStudioApplicationId1", ids.Applications[0].Id)
     * 		nameRegex, err := bp.GetStudioApplications(ctx, &bp.GetStudioApplicationsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Application"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("bpStudioApplicationId2", nameRegex.Applications[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bp.BpFunctions;
     * import com.pulumi.alicloud.bp.inputs.GetStudioApplicationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = BpFunctions.getStudioApplications(GetStudioApplicationsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("bpStudioApplicationId1", ids.applyValue(getStudioApplicationsResult -> getStudioApplicationsResult.applications()[0].id()));
     *         final var nameRegex = BpFunctions.getStudioApplications(GetStudioApplicationsArgs.builder()
     *             .nameRegex("^my-Application")
     *             .build());
     *         ctx.export("bpStudioApplicationId2", nameRegex.applyValue(getStudioApplicationsResult -> getStudioApplicationsResult.applications()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:bp:getStudioApplications
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:bp:getStudioApplications
     *       Arguments:
     *         nameRegex: ^my-Application
     * outputs:
     *   bpStudioApplicationId1: ${ids.applications[0].id}
     *   bpStudioApplicationId2: ${nameRegex.applications[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getStudioApplications.
     * @return A collection of values returned by getStudioApplications.
     */
    public suspend fun getStudioApplications(argument: GetStudioApplicationsPlainArgs): GetStudioApplicationsResult = toKotlin(getStudioApplicationsPlain(argument.toJava()).await())

    /**
     * @see [getStudioApplications].
     * @param ids A list of Application IDs.
     * @param keyword The keyword of the Application.
     * @param maxResults
     * @param nameRegex A regex string to filter results by Application name.
     * @param orderType The order type of the Application. Valid values:
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param resourceGroupId The ID of the resource group.
     * @param status The status of the Application. Valid values: `success`, `release`.
     * @return A collection of values returned by getStudioApplications.
     */
    public suspend fun getStudioApplications(
        ids: List<String>? = null,
        keyword: String? = null,
        maxResults: Int? = null,
        nameRegex: String? = null,
        orderType: Int? = null,
        outputFile: String? = null,
        resourceGroupId: String? = null,
        status: String? = null,
    ): GetStudioApplicationsResult {
        val argument = GetStudioApplicationsPlainArgs(
            ids = ids,
            keyword = keyword,
            maxResults = maxResults,
            nameRegex = nameRegex,
            orderType = orderType,
            outputFile = outputFile,
            resourceGroupId = resourceGroupId,
            status = status,
        )
        return toKotlin(getStudioApplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getStudioApplications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bp&#46;kotlin&#46;inputs&#46;GetStudioApplicationsPlainArgs].
     * @return A collection of values returned by getStudioApplications.
     */
    public suspend fun getStudioApplications(argument: suspend GetStudioApplicationsPlainArgsBuilder.() -> Unit): GetStudioApplicationsResult {
        val builder = GetStudioApplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getStudioApplicationsPlain(builtArgument.toJava()).await())
    }
}
