@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin

import com.pulumi.alicloud.bp.kotlin.outputs.StudioApplicationInstance
import com.pulumi.alicloud.bp.kotlin.outputs.StudioApplicationInstance.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [StudioApplication].
 */
@PulumiTagMarker
public class StudioApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudioApplicationArgs = StudioApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudioApplicationArgsBuilder.() -> Unit) {
        val builder = StudioApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StudioApplication {
        val builtJavaResource = com.pulumi.alicloud.bp.StudioApplication(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StudioApplication(builtJavaResource)
    }
}

/**
 * Provides a Cloud Architect Design Tools Application resource.
 * For information about Cloud Architect Design Tools Application and how to use it, see [What is Application](https://help.aliyun.com/document_detail/428263.html).
 * > **NOTE:** Available in v1.192.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetInstances = alicloud.ecs.getInstances({
 *     status: "Running",
 * });
 * const defaultStudioApplication = new alicloud.bp.StudioApplication("default", {
 *     applicationName: name,
 *     templateId: "YAUUQIYRSV1CMFGX",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     areaId: "cn-hangzhou",
 *     instances: [{
 *         id: "data.alicloud_instances.default.instances.0.id",
 *         nodeName: "data.alicloud_instances.default.instances.0.name",
 *         nodeType: "ecs",
 *     }],
 *     configuration: {
 *         enableMonitor: "1",
 *     },
 *     variables: {
 *         test: "1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_instances = alicloud.ecs.get_instances(status="Running")
 * default_studio_application = alicloud.bp.StudioApplication("default",
 *     application_name=name,
 *     template_id="YAUUQIYRSV1CMFGX",
 *     resource_group_id=default.groups[0].id,
 *     area_id="cn-hangzhou",
 *     instances=[{
 *         "id": "data.alicloud_instances.default.instances.0.id",
 *         "node_name": "data.alicloud_instances.default.instances.0.name",
 *         "node_type": "ecs",
 *     }],
 *     configuration={
 *         "enableMonitor": "1",
 *     },
 *     variables={
 *         "test": "1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetInstances = AliCloud.Ecs.GetInstances.Invoke(new()
 *     {
 *         Status = "Running",
 *     });
 *     var defaultStudioApplication = new AliCloud.Bp.StudioApplication("default", new()
 *     {
 *         ApplicationName = name,
 *         TemplateId = "YAUUQIYRSV1CMFGX",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         AreaId = "cn-hangzhou",
 *         Instances = new[]
 *         {
 *             new AliCloud.Bp.Inputs.StudioApplicationInstanceArgs
 *             {
 *                 Id = "data.alicloud_instances.default.instances.0.id",
 *                 NodeName = "data.alicloud_instances.default.instances.0.name",
 *                 NodeType = "ecs",
 *             },
 *         },
 *         Configuration =
 *         {
 *             { "enableMonitor", "1" },
 *         },
 *         Variables =
 *         {
 *             { "test", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bp"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
 * 			Status: pulumi.StringRef("Running"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = bp.NewStudioApplication(ctx, "default", &bp.StudioApplicationArgs{
 * 			ApplicationName: pulumi.String(name),
 * 			TemplateId:      pulumi.String("YAUUQIYRSV1CMFGX"),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 			AreaId:          pulumi.String("cn-hangzhou"),
 * 			Instances: bp.StudioApplicationInstanceArray{
 * 				&bp.StudioApplicationInstanceArgs{
 * 					Id:       pulumi.String("data.alicloud_instances.default.instances.0.id"),
 * 					NodeName: pulumi.String("data.alicloud_instances.default.instances.0.name"),
 * 					NodeType: pulumi.String("ecs"),
 * 				},
 * 			},
 * 			Configuration: pulumi.StringMap{
 * 				"enableMonitor": pulumi.String("1"),
 * 			},
 * 			Variables: pulumi.StringMap{
 * 				"test": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.bp.StudioApplication;
 * import com.pulumi.alicloud.bp.StudioApplicationArgs;
 * import com.pulumi.alicloud.bp.inputs.StudioApplicationInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetInstances = EcsFunctions.getInstances(GetInstancesArgs.builder()
 *             .status("Running")
 *             .build());
 *         var defaultStudioApplication = new StudioApplication("defaultStudioApplication", StudioApplicationArgs.builder()
 *             .applicationName(name)
 *             .templateId("YAUUQIYRSV1CMFGX")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .areaId("cn-hangzhou")
 *             .instances(StudioApplicationInstanceArgs.builder()
 *                 .id("data.alicloud_instances.default.instances.0.id")
 *                 .nodeName("data.alicloud_instances.default.instances.0.name")
 *                 .nodeType("ecs")
 *                 .build())
 *             .configuration(Map.of("enableMonitor", "1"))
 *             .variables(Map.of("test", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultStudioApplication:
 *     type: alicloud:bp:StudioApplication
 *     name: default
 *     properties:
 *       applicationName: ${name}
 *       templateId: YAUUQIYRSV1CMFGX
 *       resourceGroupId: ${default.groups[0].id}
 *       areaId: cn-hangzhou
 *       instances:
 *         - id: data.alicloud_instances.default.instances.0.id
 *           nodeName: data.alicloud_instances.default.instances.0.name
 *           nodeType: ecs
 *       configuration:
 *         enableMonitor: '1'
 *       variables:
 *         test: '1'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetInstances:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstances
 *       Arguments:
 *         status: Running
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Architect Design Tools Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:bp/studioApplication:StudioApplication example <id>
 * ```
 */
public class StudioApplication internal constructor(
    override val javaResource: com.pulumi.alicloud.bp.StudioApplication,
) : KotlinCustomResource(javaResource, StudioApplicationMapper) {
    /**
     * The name of the application.
     */
    public val applicationName: Output<String>
        get() = javaResource.applicationName().applyValue({ args0 -> args0 })

    /**
     * The id of the area.
     */
    public val areaId: Output<String>?
        get() = javaResource.areaId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The configuration of the application.
     */
    public val configuration: Output<Map<String, String>>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    public val instances: Output<List<StudioApplicationInstance>>?
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The id of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the Application.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The id of the template.
     */
    public val templateId: Output<String>
        get() = javaResource.templateId().applyValue({ args0 -> args0 })

    /**
     * The variables of the application.
     */
    public val variables: Output<Map<String, String>>?
        get() = javaResource.variables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object StudioApplicationMapper : ResourceMapper<StudioApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.bp.StudioApplication::class == javaResource::class

    override fun map(javaResource: Resource): StudioApplication = StudioApplication(
        javaResource as
            com.pulumi.alicloud.bp.StudioApplication,
    )
}

/**
 * @see [StudioApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StudioApplication].
 */
public suspend fun studioApplication(
    name: String,
    block: suspend StudioApplicationResourceBuilder.() -> Unit,
): StudioApplication {
    val builder = StudioApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StudioApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun studioApplication(name: String): StudioApplication {
    val builder = StudioApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
