@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin

import com.pulumi.alicloud.bp.StudioApplicationArgs.builder
import com.pulumi.alicloud.bp.kotlin.inputs.StudioApplicationInstanceArgs
import com.pulumi.alicloud.bp.kotlin.inputs.StudioApplicationInstanceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Architect Design Tools Application resource.
 * For information about Cloud Architect Design Tools Application and how to use it, see [What is Application](https://help.aliyun.com/document_detail/428263.html).
 * > **NOTE:** Available in v1.192.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetInstances = alicloud.ecs.getInstances({
 *     status: "Running",
 * });
 * const defaultStudioApplication = new alicloud.bp.StudioApplication("default", {
 *     applicationName: name,
 *     templateId: "YAUUQIYRSV1CMFGX",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     areaId: "cn-hangzhou",
 *     instances: [{
 *         id: "data.alicloud_instances.default.instances.0.id",
 *         nodeName: "data.alicloud_instances.default.instances.0.name",
 *         nodeType: "ecs",
 *     }],
 *     configuration: {
 *         enableMonitor: "1",
 *     },
 *     variables: {
 *         test: "1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_instances = alicloud.ecs.get_instances(status="Running")
 * default_studio_application = alicloud.bp.StudioApplication("default",
 *     application_name=name,
 *     template_id="YAUUQIYRSV1CMFGX",
 *     resource_group_id=default.groups[0].id,
 *     area_id="cn-hangzhou",
 *     instances=[{
 *         "id": "data.alicloud_instances.default.instances.0.id",
 *         "node_name": "data.alicloud_instances.default.instances.0.name",
 *         "node_type": "ecs",
 *     }],
 *     configuration={
 *         "enableMonitor": "1",
 *     },
 *     variables={
 *         "test": "1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetInstances = AliCloud.Ecs.GetInstances.Invoke(new()
 *     {
 *         Status = "Running",
 *     });
 *     var defaultStudioApplication = new AliCloud.Bp.StudioApplication("default", new()
 *     {
 *         ApplicationName = name,
 *         TemplateId = "YAUUQIYRSV1CMFGX",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         AreaId = "cn-hangzhou",
 *         Instances = new[]
 *         {
 *             new AliCloud.Bp.Inputs.StudioApplicationInstanceArgs
 *             {
 *                 Id = "data.alicloud_instances.default.instances.0.id",
 *                 NodeName = "data.alicloud_instances.default.instances.0.name",
 *                 NodeType = "ecs",
 *             },
 *         },
 *         Configuration =
 *         {
 *             { "enableMonitor", "1" },
 *         },
 *         Variables =
 *         {
 *             { "test", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bp"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetInstances(ctx, &ecs.GetInstancesArgs{
 * 			Status: pulumi.StringRef("Running"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = bp.NewStudioApplication(ctx, "default", &bp.StudioApplicationArgs{
 * 			ApplicationName: pulumi.String(name),
 * 			TemplateId:      pulumi.String("YAUUQIYRSV1CMFGX"),
 * 			ResourceGroupId: pulumi.String(_default.Groups[0].Id),
 * 			AreaId:          pulumi.String("cn-hangzhou"),
 * 			Instances: bp.StudioApplicationInstanceArray{
 * 				&bp.StudioApplicationInstanceArgs{
 * 					Id:       pulumi.String("data.alicloud_instances.default.instances.0.id"),
 * 					NodeName: pulumi.String("data.alicloud_instances.default.instances.0.name"),
 * 					NodeType: pulumi.String("ecs"),
 * 				},
 * 			},
 * 			Configuration: pulumi.StringMap{
 * 				"enableMonitor": pulumi.String("1"),
 * 			},
 * 			Variables: pulumi.StringMap{
 * 				"test": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstancesArgs;
 * import com.pulumi.alicloud.bp.StudioApplication;
 * import com.pulumi.alicloud.bp.StudioApplicationArgs;
 * import com.pulumi.alicloud.bp.inputs.StudioApplicationInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetInstances = EcsFunctions.getInstances(GetInstancesArgs.builder()
 *             .status("Running")
 *             .build());
 *         var defaultStudioApplication = new StudioApplication("defaultStudioApplication", StudioApplicationArgs.builder()
 *             .applicationName(name)
 *             .templateId("YAUUQIYRSV1CMFGX")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .areaId("cn-hangzhou")
 *             .instances(StudioApplicationInstanceArgs.builder()
 *                 .id("data.alicloud_instances.default.instances.0.id")
 *                 .nodeName("data.alicloud_instances.default.instances.0.name")
 *                 .nodeType("ecs")
 *                 .build())
 *             .configuration(Map.of("enableMonitor", "1"))
 *             .variables(Map.of("test", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   defaultStudioApplication:
 *     type: alicloud:bp:StudioApplication
 *     name: default
 *     properties:
 *       applicationName: ${name}
 *       templateId: YAUUQIYRSV1CMFGX
 *       resourceGroupId: ${default.groups[0].id}
 *       areaId: cn-hangzhou
 *       instances:
 *         - id: data.alicloud_instances.default.instances.0.id
 *           nodeName: data.alicloud_instances.default.instances.0.name
 *           nodeType: ecs
 *       configuration:
 *         enableMonitor: '1'
 *       variables:
 *         test: '1'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetInstances:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstances
 *       Arguments:
 *         status: Running
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Architect Design Tools Application can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:bp/studioApplication:StudioApplication example <id>
 * ```
 * @property applicationName The name of the application.
 * @property areaId The id of the area.
 * @property configuration The configuration of the application.
 * @property instances The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
 * @property resourceGroupId The id of the resource group.
 * @property templateId The id of the template.
 * @property variables The variables of the application.
 */
public data class StudioApplicationArgs(
    public val applicationName: Output<String>? = null,
    public val areaId: Output<String>? = null,
    public val configuration: Output<Map<String, String>>? = null,
    public val instances: Output<List<StudioApplicationInstanceArgs>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val templateId: Output<String>? = null,
    public val variables: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bp.StudioApplicationArgs> {
    override fun toJava(): com.pulumi.alicloud.bp.StudioApplicationArgs =
        com.pulumi.alicloud.bp.StudioApplicationArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .areaId(areaId?.applyValue({ args0 -> args0 }))
            .configuration(
                configuration?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .instances(
                instances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StudioApplicationArgs].
 */
@PulumiTagMarker
public class StudioApplicationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var areaId: Output<String>? = null

    private var configuration: Output<Map<String, String>>? = null

    private var instances: Output<List<StudioApplicationInstanceArgs>>? = null

    private var resourceGroupId: Output<String>? = null

    private var templateId: Output<String>? = null

    private var variables: Output<Map<String, String>>? = null

    /**
     * @param value The name of the application.
     */
    @JvmName("hmexchlrgbmwyxjq")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The id of the area.
     */
    @JvmName("wdxrnguphcnfqqag")
    public suspend fun areaId(`value`: Output<String>) {
        this.areaId = value
    }

    /**
     * @param value The configuration of the application.
     */
    @JvmName("hnlqukhnrhmaopfa")
    public suspend fun configuration(`value`: Output<Map<String, String>>) {
        this.configuration = value
    }

    /**
     * @param value The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("pjadueapjbkbddpq")
    public suspend fun instances(`value`: Output<List<StudioApplicationInstanceArgs>>) {
        this.instances = value
    }

    @JvmName("pmfqktjkvibiaoyj")
    public suspend fun instances(vararg values: Output<StudioApplicationInstanceArgs>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("ivbitksdvbbcrjth")
    public suspend fun instances(values: List<Output<StudioApplicationInstanceArgs>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The id of the resource group.
     */
    @JvmName("tjswuaglhutitsui")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The id of the template.
     */
    @JvmName("tnwjhkpowuexwkre")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value The variables of the application.
     */
    @JvmName("omrobohlgsfydvwc")
    public suspend fun variables(`value`: Output<Map<String, String>>) {
        this.variables = value
    }

    /**
     * @param value The name of the application.
     */
    @JvmName("idqkrrqqtmbvyaxo")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The id of the area.
     */
    @JvmName("djpvgevflqhhfmor")
    public suspend fun areaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.areaId = mapped
    }

    /**
     * @param value The configuration of the application.
     */
    @JvmName("tqcyfjwqgwerjwyt")
    public suspend fun configuration(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param values The configuration of the application.
     */
    @JvmName("cgoahrkmyoyxndvi")
    public fun configuration(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param value The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("noqxhiqikiktxqpv")
    public suspend fun instances(`value`: List<StudioApplicationInstanceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param argument The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("uufwauxcsqwmgeul")
    public suspend fun instances(argument: List<suspend StudioApplicationInstanceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StudioApplicationInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("grqxuotlbfmtyylx")
    public suspend fun instances(vararg argument: suspend StudioApplicationInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StudioApplicationInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("xlkxgxlttetgmkdr")
    public suspend fun instances(argument: suspend StudioApplicationInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StudioApplicationInstanceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param values The instance list. Support the creation of instances in the existing vpc under the application. See the following `Block instances`.
     */
    @JvmName("klcsfboylyunlucv")
    public suspend fun instances(vararg values: StudioApplicationInstanceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The id of the resource group.
     */
    @JvmName("thlrurlhpxnskvtw")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The id of the template.
     */
    @JvmName("imgqoqomxxerktro")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value The variables of the application.
     */
    @JvmName("iedfofydittpdsac")
    public suspend fun variables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param values The variables of the application.
     */
    @JvmName("aqgdttumwkdyacgw")
    public fun variables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    internal fun build(): StudioApplicationArgs = StudioApplicationArgs(
        applicationName = applicationName,
        areaId = areaId,
        configuration = configuration,
        instances = instances,
        resourceGroupId = resourceGroupId,
        templateId = templateId,
        variables = variables,
    )
}
