@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin.inputs

import com.pulumi.alicloud.bp.inputs.GetStudioApplicationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getStudioApplications.
 * @property ids A list of Application IDs.
 * @property keyword The keyword of the Application.
 * @property maxResults
 * @property nameRegex A regex string to filter results by Application name.
 * @property orderType The order type of the Application. Valid values:
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the Application. Valid values: `success`, `release`.
 */
public data class GetStudioApplicationsPlainArgs(
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val maxResults: Int? = null,
    public val nameRegex: String? = null,
    public val orderType: Int? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bp.inputs.GetStudioApplicationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bp.inputs.GetStudioApplicationsPlainArgs =
        com.pulumi.alicloud.bp.inputs.GetStudioApplicationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .maxResults(maxResults?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .orderType(orderType?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStudioApplicationsPlainArgs].
 */
@PulumiTagMarker
public class GetStudioApplicationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyword: String? = null

    private var maxResults: Int? = null

    private var nameRegex: String? = null

    private var orderType: Int? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var status: String? = null

    /**
     * @param value A list of Application IDs.
     */
    @JvmName("xlevsvwtarufhhnx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Application IDs.
     */
    @JvmName("olhjfqnybvwntkpy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The keyword of the Application.
     */
    @JvmName("sgbkimluvpgfnxsp")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value
     */
    @JvmName("orlargqgfemxuolg")
    public suspend fun maxResults(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxResults = mapped
    }

    /**
     * @param value A regex string to filter results by Application name.
     */
    @JvmName("nssfuvyjgnebidjj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The order type of the Application. Valid values:
     */
    @JvmName("vlmgtdpbfahemxpd")
    public suspend fun orderType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderType = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rmbgtkghnjkobdjh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("afaebokokrvfopno")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the Application. Valid values: `success`, `release`.
     */
    @JvmName("cmibufuohyjtviyc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetStudioApplicationsPlainArgs = GetStudioApplicationsPlainArgs(
        ids = ids,
        keyword = keyword,
        maxResults = maxResults,
        nameRegex = nameRegex,
        orderType = orderType,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        status = status,
    )
}
