@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin.inputs

import com.pulumi.alicloud.bp.inputs.StudioApplicationInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The id of the instance.
 * @property nodeName The name of the instance.
 * @property nodeType The type of the instance.
 */
public data class StudioApplicationInstanceArgs(
    public val id: Output<String>? = null,
    public val nodeName: Output<String>? = null,
    public val nodeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bp.inputs.StudioApplicationInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.bp.inputs.StudioApplicationInstanceArgs =
        com.pulumi.alicloud.bp.inputs.StudioApplicationInstanceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .nodeName(nodeName?.applyValue({ args0 -> args0 }))
            .nodeType(nodeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StudioApplicationInstanceArgs].
 */
@PulumiTagMarker
public class StudioApplicationInstanceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var nodeName: Output<String>? = null

    private var nodeType: Output<String>? = null

    /**
     * @param value The id of the instance.
     */
    @JvmName("glbsxxvpwqofwiou")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("lkfqrkowqpptmsof")
    public suspend fun nodeName(`value`: Output<String>) {
        this.nodeName = value
    }

    /**
     * @param value The type of the instance.
     */
    @JvmName("fbpkbmlsbkpujxnd")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value The id of the instance.
     */
    @JvmName("wtljdlaxhvihppxr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("owlefotimsvaekco")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeName = mapped
    }

    /**
     * @param value The type of the instance.
     */
    @JvmName("biopjxinrcjtfuyp")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    internal fun build(): StudioApplicationInstanceArgs = StudioApplicationInstanceArgs(
        id = id,
        nodeName = nodeName,
        nodeType = nodeType,
    )
}
