@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationId The ID of the Application.
 * @property applicationName The name of the Application.
 * @property createTime The creation time of the Application.
 * @property id The ID of the Application.
 * @property imageUrl The image url of the Application.
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the Application. Valid values: `success`, `release`.
 * @property topoUrl The topo url of the Application.
 */
public data class GetStudioApplicationsApplication(
    public val applicationId: String,
    public val applicationName: String,
    public val createTime: String,
    public val id: String,
    public val imageUrl: String,
    public val resourceGroupId: String,
    public val status: String,
    public val topoUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bp.outputs.GetStudioApplicationsApplication): GetStudioApplicationsApplication = GetStudioApplicationsApplication(
            applicationId = javaType.applicationId(),
            applicationName = javaType.applicationName(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            imageUrl = javaType.imageUrl(),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            topoUrl = javaType.topoUrl(),
        )
    }
}
