@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getStudioApplications.
 * @property applications A list of Cloud Architect Design Tools (BPStudio) Applications. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property keyword
 * @property maxResults
 * @property nameRegex
 * @property names A list of Application names.
 * @property orderType
 * @property outputFile
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the Application.
 */
public data class GetStudioApplicationsResult(
    public val applications: List<GetStudioApplicationsApplication>,
    public val id: String,
    public val ids: List<String>,
    public val keyword: String? = null,
    public val maxResults: Int? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val orderType: Int? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bp.outputs.GetStudioApplicationsResult): GetStudioApplicationsResult = GetStudioApplicationsResult(
            applications = javaType.applications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bp.kotlin.outputs.GetStudioApplicationsApplication.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyword = javaType.keyword().map({ args0 -> args0 }).orElse(null),
            maxResults = javaType.maxResults().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            orderType = javaType.orderType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
