@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The id of the instance.
 * @property nodeName The name of the instance.
 * @property nodeType The type of the instance.
 */
public data class StudioApplicationInstance(
    public val id: String? = null,
    public val nodeName: String? = null,
    public val nodeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bp.outputs.StudioApplicationInstance): StudioApplicationInstance = StudioApplicationInstance(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            nodeName = javaType.nodeName().map({ args0 -> args0 }).orElse(null),
            nodeType = javaType.nodeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
