@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.alicloud.brain.BrainFunctions.getIndustrialPidLoopsPlain
import com.pulumi.alicloud.brain.BrainFunctions.getIndustrialPidOrganizationsPlain
import com.pulumi.alicloud.brain.BrainFunctions.getIndustrialPidProjectsPlain
import com.pulumi.alicloud.brain.BrainFunctions.getIndustrialSericePlain
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialPidLoopsPlainArgs
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialPidLoopsPlainArgsBuilder
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialPidOrganizationsPlainArgs
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialPidOrganizationsPlainArgsBuilder
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialPidProjectsPlainArgs
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialPidProjectsPlainArgsBuilder
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialSericePlainArgs
import com.pulumi.alicloud.brain.kotlin.inputs.GetIndustrialSericePlainArgsBuilder
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidLoopsResult
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidOrganizationsResult
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidProjectsResult
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialSericeResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidLoopsResult.Companion.toKotlin as getIndustrialPidLoopsResultToKotlin
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidOrganizationsResult.Companion.toKotlin as getIndustrialPidOrganizationsResultToKotlin
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidProjectsResult.Companion.toKotlin as getIndustrialPidProjectsResultToKotlin
import com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialSericeResult.Companion.toKotlin as getIndustrialSericeResultToKotlin

public object BrainFunctions {
    /**
     * This data source provides the Brain Industrial Pid Loops of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.117.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.brain.getIndustrialPidLoops({
     *     pidProjectId: "856c6b8f-ca63-40a4-xxxx-xxxx",
     *     ids: ["742a3d4e-d8b0-47c8-xxxx-xxxx"],
     *     nameRegex: "tf-testACC",
     * });
     * export const firstBrainIndustrialPidLoopId = example.then(example => example.loops?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.brain.get_industrial_pid_loops(pid_project_id="856c6b8f-ca63-40a4-xxxx-xxxx",
     *     ids=["742a3d4e-d8b0-47c8-xxxx-xxxx"],
     *     name_regex="tf-testACC")
     * pulumi.export("firstBrainIndustrialPidLoopId", example.loops[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Brain.GetIndustrialPidLoops.Invoke(new()
     *     {
     *         PidProjectId = "856c6b8f-ca63-40a4-xxxx-xxxx",
     *         Ids = new[]
     *         {
     *             "742a3d4e-d8b0-47c8-xxxx-xxxx",
     *         },
     *         NameRegex = "tf-testACC",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstBrainIndustrialPidLoopId"] = example&#46;Apply(getIndustrialPidLoopsResult => getIndustrialPidLoopsResult&#46;Loops[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := brain.GetIndustrialPidLoops(ctx, &brain.GetIndustrialPidLoopsArgs{
     * 			PidProjectId: "856c6b8f-ca63-40a4-xxxx-xxxx",
     * 			Ids: []string{
     * 				"742a3d4e-d8b0-47c8-xxxx-xxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testACC"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstBrainIndustrialPidLoopId", example.Loops[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.brain.BrainFunctions;
     * import com.pulumi.alicloud.brain.inputs.GetIndustrialPidLoopsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BrainFunctions.getIndustrialPidLoops(GetIndustrialPidLoopsArgs.builder()
     *             .pidProjectId("856c6b8f-ca63-40a4-xxxx-xxxx")
     *             .ids("742a3d4e-d8b0-47c8-xxxx-xxxx")
     *             .nameRegex("tf-testACC")
     *             .build());
     *         ctx.export("firstBrainIndustrialPidLoopId", example.applyValue(getIndustrialPidLoopsResult -> getIndustrialPidLoopsResult.loops()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:brain:getIndustrialPidLoops
     *       Arguments:
     *         pidProjectId: 856c6b8f-ca63-40a4-xxxx-xxxx
     *         ids:
     *           - 742a3d4e-d8b0-47c8-xxxx-xxxx
     *         nameRegex: tf-testACC
     * outputs:
     *   firstBrainIndustrialPidLoopId: ${example.loops[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIndustrialPidLoops.
     * @return A collection of values returned by getIndustrialPidLoops.
     */
    public suspend fun getIndustrialPidLoops(argument: GetIndustrialPidLoopsPlainArgs): GetIndustrialPidLoopsResult =
        getIndustrialPidLoopsResultToKotlin(getIndustrialPidLoopsPlain(argument.toJava()).await())

    /**
     * @see [getIndustrialPidLoops].
     * @param enableDetails
     * @param ids A list of Pid Loop IDs.
     * @param nameRegex A regex string to filter results by Pid Loop name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pidLoopName The name of Pid Loop.
     * @param pidProjectId The pid project id.
     * @param status The status of Pid Loop.
     * @return A collection of values returned by getIndustrialPidLoops.
     */
    public suspend fun getIndustrialPidLoops(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pidLoopName: String? = null,
        pidProjectId: String,
        status: String? = null,
    ): GetIndustrialPidLoopsResult {
        val argument = GetIndustrialPidLoopsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pidLoopName = pidLoopName,
            pidProjectId = pidProjectId,
            status = status,
        )
        return getIndustrialPidLoopsResultToKotlin(getIndustrialPidLoopsPlain(argument.toJava()).await())
    }

    /**
     * @see [getIndustrialPidLoops].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;brain&#46;kotlin&#46;inputs&#46;GetIndustrialPidLoopsPlainArgs].
     * @return A collection of values returned by getIndustrialPidLoops.
     */
    public suspend fun getIndustrialPidLoops(argument: suspend GetIndustrialPidLoopsPlainArgsBuilder.() -> Unit): GetIndustrialPidLoopsResult {
        val builder = GetIndustrialPidLoopsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIndustrialPidLoopsResultToKotlin(getIndustrialPidLoopsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Brain Industrial Pid Organizations of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.113.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.brain.getIndustrialPidOrganizations({
     *     ids: ["3e74e684-cbb5-xxxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstBrainIndustrialPidOrganizationId = example.then(example => example.organizations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.brain.get_industrial_pid_organizations(ids=["3e74e684-cbb5-xxxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstBrainIndustrialPidOrganizationId", example.organizations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Brain.GetIndustrialPidOrganizations.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "3e74e684-cbb5-xxxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstBrainIndustrialPidOrganizationId"] = example&#46;Apply(getIndustrialPidOrganizationsResult => getIndustrialPidOrganizationsResult&#46;Organizations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := brain.GetIndustrialPidOrganizations(ctx, &brain.GetIndustrialPidOrganizationsArgs{
     * 			Ids: []string{
     * 				"3e74e684-cbb5-xxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstBrainIndustrialPidOrganizationId", example.Organizations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.brain.BrainFunctions;
     * import com.pulumi.alicloud.brain.inputs.GetIndustrialPidOrganizationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BrainFunctions.getIndustrialPidOrganizations(GetIndustrialPidOrganizationsArgs.builder()
     *             .ids("3e74e684-cbb5-xxxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstBrainIndustrialPidOrganizationId", example.applyValue(getIndustrialPidOrganizationsResult -> getIndustrialPidOrganizationsResult.organizations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:brain:getIndustrialPidOrganizations
     *       Arguments:
     *         ids:
     *           - 3e74e684-cbb5-xxxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstBrainIndustrialPidOrganizationId: ${example.organizations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIndustrialPidOrganizations.
     * @return A collection of values returned by getIndustrialPidOrganizations.
     */
    public suspend fun getIndustrialPidOrganizations(argument: GetIndustrialPidOrganizationsPlainArgs): GetIndustrialPidOrganizationsResult =
        getIndustrialPidOrganizationsResultToKotlin(getIndustrialPidOrganizationsPlain(argument.toJava()).await())

    /**
     * @see [getIndustrialPidOrganizations].
     * @param ids A list of Pid Organization IDs.
     * @param nameRegex A regex string to filter results by Pid Organization name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param parentOrganizationId The parent organization id.
     * @return A collection of values returned by getIndustrialPidOrganizations.
     */
    public suspend fun getIndustrialPidOrganizations(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        parentOrganizationId: String? = null,
    ): GetIndustrialPidOrganizationsResult {
        val argument = GetIndustrialPidOrganizationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parentOrganizationId = parentOrganizationId,
        )
        return getIndustrialPidOrganizationsResultToKotlin(getIndustrialPidOrganizationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getIndustrialPidOrganizations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;brain&#46;kotlin&#46;inputs&#46;GetIndustrialPidOrganizationsPlainArgs].
     * @return A collection of values returned by getIndustrialPidOrganizations.
     */
    public suspend fun getIndustrialPidOrganizations(argument: suspend GetIndustrialPidOrganizationsPlainArgsBuilder.() -> Unit): GetIndustrialPidOrganizationsResult {
        val builder = GetIndustrialPidOrganizationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIndustrialPidOrganizationsResultToKotlin(getIndustrialPidOrganizationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Brain Industrial Pid Projects of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.113.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.brain.getIndustrialPidProjects({
     *     ids: ["3e74e684-cbb5-xxxx"],
     *     nameRegex: "tf-testAcc",
     * });
     * export const firstBrainIndustrialPidProjectId = example.then(example => example.projects?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.brain.get_industrial_pid_projects(ids=["3e74e684-cbb5-xxxx"],
     *     name_regex="tf-testAcc")
     * pulumi.export("firstBrainIndustrialPidProjectId", example.projects[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Brain.GetIndustrialPidProjects.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "3e74e684-cbb5-xxxx",
     *         },
     *         NameRegex = "tf-testAcc",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstBrainIndustrialPidProjectId"] = example&#46;Apply(getIndustrialPidProjectsResult => getIndustrialPidProjectsResult&#46;Projects[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := brain.GetIndustrialPidProjects(ctx, &brain.GetIndustrialPidProjectsArgs{
     * 			Ids: []string{
     * 				"3e74e684-cbb5-xxxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("tf-testAcc"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstBrainIndustrialPidProjectId", example.Projects[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.brain.BrainFunctions;
     * import com.pulumi.alicloud.brain.inputs.GetIndustrialPidProjectsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = BrainFunctions.getIndustrialPidProjects(GetIndustrialPidProjectsArgs.builder()
     *             .ids("3e74e684-cbb5-xxxx")
     *             .nameRegex("tf-testAcc")
     *             .build());
     *         ctx.export("firstBrainIndustrialPidProjectId", example.applyValue(getIndustrialPidProjectsResult -> getIndustrialPidProjectsResult.projects()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:brain:getIndustrialPidProjects
     *       Arguments:
     *         ids:
     *           - 3e74e684-cbb5-xxxx
     *         nameRegex: tf-testAcc
     * outputs:
     *   firstBrainIndustrialPidProjectId: ${example.projects[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIndustrialPidProjects.
     * @return A collection of values returned by getIndustrialPidProjects.
     */
    public suspend fun getIndustrialPidProjects(argument: GetIndustrialPidProjectsPlainArgs): GetIndustrialPidProjectsResult =
        getIndustrialPidProjectsResultToKotlin(getIndustrialPidProjectsPlain(argument.toJava()).await())

    /**
     * @see [getIndustrialPidProjects].
     * @param ids A list of Pid Project IDs.
     * @param nameRegex A regex string to filter results by Pid Project name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pidOrganizationId The ID of Pid Organization.
     * @param pidProjectName The name of Pid Project.
     * @return A collection of values returned by getIndustrialPidProjects.
     */
    public suspend fun getIndustrialPidProjects(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pidOrganizationId: String? = null,
        pidProjectName: String? = null,
    ): GetIndustrialPidProjectsResult {
        val argument = GetIndustrialPidProjectsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pidOrganizationId = pidOrganizationId,
            pidProjectName = pidProjectName,
        )
        return getIndustrialPidProjectsResultToKotlin(getIndustrialPidProjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getIndustrialPidProjects].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;brain&#46;kotlin&#46;inputs&#46;GetIndustrialPidProjectsPlainArgs].
     * @return A collection of values returned by getIndustrialPidProjects.
     */
    public suspend fun getIndustrialPidProjects(argument: suspend GetIndustrialPidProjectsPlainArgsBuilder.() -> Unit): GetIndustrialPidProjectsResult {
        val builder = GetIndustrialPidProjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIndustrialPidProjectsResultToKotlin(getIndustrialPidProjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Brain Industrial service automatically. If the service has been opened, it will return opened.
     * > **NOTE:** Available in v1.115.0+
     * > **NOTE:** The Brain Industrial service is not support in the international site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.brain.getIndustrialSerice({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.brain.get_industrial_serice(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Brain.GetIndustrialSerice.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := brain.GetIndustrialSerice(ctx, &brain.GetIndustrialSericeArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.brain.BrainFunctions;
     * import com.pulumi.alicloud.brain.inputs.GetIndustrialSericeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = BrainFunctions.getIndustrialSerice(GetIndustrialSericeArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:brain:getIndustrialSerice
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIndustrialSerice.
     * @return A collection of values returned by getIndustrialSerice.
     */
    public suspend fun getIndustrialSerice(argument: GetIndustrialSericePlainArgs): GetIndustrialSericeResult =
        getIndustrialSericeResultToKotlin(getIndustrialSericePlain(argument.toJava()).await())

    /**
     * @see [getIndustrialSerice].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Brain Industrial service. The service can not closed once it is opened.
     * @return A collection of values returned by getIndustrialSerice.
     */
    public suspend fun getIndustrialSerice(enable: String? = null): GetIndustrialSericeResult {
        val argument = GetIndustrialSericePlainArgs(
            enable = enable,
        )
        return getIndustrialSericeResultToKotlin(getIndustrialSericePlain(argument.toJava()).await())
    }

    /**
     * @see [getIndustrialSerice].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;brain&#46;kotlin&#46;inputs&#46;GetIndustrialSericePlainArgs].
     * @return A collection of values returned by getIndustrialSerice.
     */
    public suspend fun getIndustrialSerice(argument: suspend GetIndustrialSericePlainArgsBuilder.() -> Unit): GetIndustrialSericeResult {
        val builder = GetIndustrialSericePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIndustrialSericeResultToKotlin(getIndustrialSericePlain(builtArgument.toJava()).await())
    }
}
