@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IndustrialPidLoop].
 */
@PulumiTagMarker
public class IndustrialPidLoopResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndustrialPidLoopArgs = IndustrialPidLoopArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndustrialPidLoopArgsBuilder.() -> Unit) {
        val builder = IndustrialPidLoopArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IndustrialPidLoop {
        val builtJavaResource = com.pulumi.alicloud.brain.IndustrialPidLoop(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IndustrialPidLoop(builtJavaResource)
    }
}

/**
 * Provides a Brain Industrial Pid Loop resource.
 * > **NOTE:** Available in v1.117.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.brain.IndustrialPidLoop("example", {
 *     pidLoopConfiguration: "YourLoopConfiguration",
 *     pidLoopDcsType: "standard",
 *     pidLoopIsCrucial: true,
 *     pidLoopName: "tf-testAcc",
 *     pidLoopType: "0",
 *     pidProjectId: "856c6b8f-ca63-40a4-xxxx-xxxx",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.brain.IndustrialPidLoop("example",
 *     pid_loop_configuration="YourLoopConfiguration",
 *     pid_loop_dcs_type="standard",
 *     pid_loop_is_crucial=True,
 *     pid_loop_name="tf-testAcc",
 *     pid_loop_type="0",
 *     pid_project_id="856c6b8f-ca63-40a4-xxxx-xxxx")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Brain.IndustrialPidLoop("example", new()
 *     {
 *         PidLoopConfiguration = "YourLoopConfiguration",
 *         PidLoopDcsType = "standard",
 *         PidLoopIsCrucial = true,
 *         PidLoopName = "tf-testAcc",
 *         PidLoopType = "0",
 *         PidProjectId = "856c6b8f-ca63-40a4-xxxx-xxxx",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := brain.NewIndustrialPidLoop(ctx, "example", &brain.IndustrialPidLoopArgs{
 * 			PidLoopConfiguration: pulumi.String("YourLoopConfiguration"),
 * 			PidLoopDcsType:       pulumi.String("standard"),
 * 			PidLoopIsCrucial:     pulumi.Bool(true),
 * 			PidLoopName:          pulumi.String("tf-testAcc"),
 * 			PidLoopType:          pulumi.String("0"),
 * 			PidProjectId:         pulumi.String("856c6b8f-ca63-40a4-xxxx-xxxx"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.brain.IndustrialPidLoop;
 * import com.pulumi.alicloud.brain.IndustrialPidLoopArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndustrialPidLoop("example", IndustrialPidLoopArgs.builder()
 *             .pidLoopConfiguration("YourLoopConfiguration")
 *             .pidLoopDcsType("standard")
 *             .pidLoopIsCrucial(true)
 *             .pidLoopName("tf-testAcc")
 *             .pidLoopType("0")
 *             .pidProjectId("856c6b8f-ca63-40a4-xxxx-xxxx")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:brain:IndustrialPidLoop
 *     properties:
 *       pidLoopConfiguration: YourLoopConfiguration
 *       pidLoopDcsType: standard
 *       pidLoopIsCrucial: true
 *       pidLoopName: tf-testAcc
 *       pidLoopType: '0'
 *       pidProjectId: 856c6b8f-ca63-40a4-xxxx-xxxx
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Brain Industrial Pid Loop can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:brain/industrialPidLoop:IndustrialPidLoop example <id>
 * ```
 */
public class IndustrialPidLoop internal constructor(
    override val javaResource: com.pulumi.alicloud.brain.IndustrialPidLoop,
) : KotlinCustomResource(javaResource, IndustrialPidLoopMapper) {
    /**
     * The Pid Loop Configuration.
     */
    public val pidLoopConfiguration: Output<String>
        get() = javaResource.pidLoopConfiguration().applyValue({ args0 -> args0 })

    /**
     * The dcs type of Pid Loop. Valid values: `standard`.
     */
    public val pidLoopDcsType: Output<String>
        get() = javaResource.pidLoopDcsType().applyValue({ args0 -> args0 })

    /**
     * The desc of Pid Loop.
     */
    public val pidLoopDesc: Output<String>?
        get() = javaResource.pidLoopDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether is crucial Pid Loop.
     */
    public val pidLoopIsCrucial: Output<Boolean>
        get() = javaResource.pidLoopIsCrucial().applyValue({ args0 -> args0 })

    /**
     * The name of Pid Loop.
     */
    public val pidLoopName: Output<String>
        get() = javaResource.pidLoopName().applyValue({ args0 -> args0 })

    /**
     * The type of Pid Loop. Valid values: `0`, `1`, `2`, `3`, `4`, `5`.
     */
    public val pidLoopType: Output<String>
        get() = javaResource.pidLoopType().applyValue({ args0 -> args0 })

    /**
     * The pid project id.
     */
    public val pidProjectId: Output<String>
        get() = javaResource.pidProjectId().applyValue({ args0 -> args0 })

    /**
     * The status of Pid Loop.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object IndustrialPidLoopMapper : ResourceMapper<IndustrialPidLoop> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.brain.IndustrialPidLoop::class == javaResource::class

    override fun map(javaResource: Resource): IndustrialPidLoop = IndustrialPidLoop(
        javaResource as
            com.pulumi.alicloud.brain.IndustrialPidLoop,
    )
}

/**
 * @see [IndustrialPidLoop].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IndustrialPidLoop].
 */
public suspend fun industrialPidLoop(
    name: String,
    block: suspend IndustrialPidLoopResourceBuilder.() -> Unit,
): IndustrialPidLoop {
    val builder = IndustrialPidLoopResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IndustrialPidLoop].
 * @param name The _unique_ name of the resulting resource.
 */
public fun industrialPidLoop(name: String): IndustrialPidLoop {
    val builder = IndustrialPidLoopResourceBuilder()
    builder.name(name)
    return builder.build()
}
