@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.alicloud.brain.IndustrialPidLoopArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Brain Industrial Pid Loop resource.
 * > **NOTE:** Available in v1.117.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.brain.IndustrialPidLoop("example", {
 *     pidLoopConfiguration: "YourLoopConfiguration",
 *     pidLoopDcsType: "standard",
 *     pidLoopIsCrucial: true,
 *     pidLoopName: "tf-testAcc",
 *     pidLoopType: "0",
 *     pidProjectId: "856c6b8f-ca63-40a4-xxxx-xxxx",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.brain.IndustrialPidLoop("example",
 *     pid_loop_configuration="YourLoopConfiguration",
 *     pid_loop_dcs_type="standard",
 *     pid_loop_is_crucial=True,
 *     pid_loop_name="tf-testAcc",
 *     pid_loop_type="0",
 *     pid_project_id="856c6b8f-ca63-40a4-xxxx-xxxx")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Brain.IndustrialPidLoop("example", new()
 *     {
 *         PidLoopConfiguration = "YourLoopConfiguration",
 *         PidLoopDcsType = "standard",
 *         PidLoopIsCrucial = true,
 *         PidLoopName = "tf-testAcc",
 *         PidLoopType = "0",
 *         PidProjectId = "856c6b8f-ca63-40a4-xxxx-xxxx",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := brain.NewIndustrialPidLoop(ctx, "example", &brain.IndustrialPidLoopArgs{
 * 			PidLoopConfiguration: pulumi.String("YourLoopConfiguration"),
 * 			PidLoopDcsType:       pulumi.String("standard"),
 * 			PidLoopIsCrucial:     pulumi.Bool(true),
 * 			PidLoopName:          pulumi.String("tf-testAcc"),
 * 			PidLoopType:          pulumi.String("0"),
 * 			PidProjectId:         pulumi.String("856c6b8f-ca63-40a4-xxxx-xxxx"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.brain.IndustrialPidLoop;
 * import com.pulumi.alicloud.brain.IndustrialPidLoopArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndustrialPidLoop("example", IndustrialPidLoopArgs.builder()
 *             .pidLoopConfiguration("YourLoopConfiguration")
 *             .pidLoopDcsType("standard")
 *             .pidLoopIsCrucial(true)
 *             .pidLoopName("tf-testAcc")
 *             .pidLoopType("0")
 *             .pidProjectId("856c6b8f-ca63-40a4-xxxx-xxxx")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:brain:IndustrialPidLoop
 *     properties:
 *       pidLoopConfiguration: YourLoopConfiguration
 *       pidLoopDcsType: standard
 *       pidLoopIsCrucial: true
 *       pidLoopName: tf-testAcc
 *       pidLoopType: '0'
 *       pidProjectId: 856c6b8f-ca63-40a4-xxxx-xxxx
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Brain Industrial Pid Loop can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:brain/industrialPidLoop:IndustrialPidLoop example <id>
 * ```
 * @property pidLoopConfiguration The Pid Loop Configuration.
 * @property pidLoopDcsType The dcs type of Pid Loop. Valid values: `standard`.
 * @property pidLoopDesc The desc of Pid Loop.
 * @property pidLoopIsCrucial Whether is crucial Pid Loop.
 * @property pidLoopName The name of Pid Loop.
 * @property pidLoopType The type of Pid Loop. Valid values: `0`, `1`, `2`, `3`, `4`, `5`.
 * @property pidProjectId The pid project id.
 */
public data class IndustrialPidLoopArgs(
    public val pidLoopConfiguration: Output<String>? = null,
    public val pidLoopDcsType: Output<String>? = null,
    public val pidLoopDesc: Output<String>? = null,
    public val pidLoopIsCrucial: Output<Boolean>? = null,
    public val pidLoopName: Output<String>? = null,
    public val pidLoopType: Output<String>? = null,
    public val pidProjectId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.IndustrialPidLoopArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.IndustrialPidLoopArgs =
        com.pulumi.alicloud.brain.IndustrialPidLoopArgs.builder()
            .pidLoopConfiguration(pidLoopConfiguration?.applyValue({ args0 -> args0 }))
            .pidLoopDcsType(pidLoopDcsType?.applyValue({ args0 -> args0 }))
            .pidLoopDesc(pidLoopDesc?.applyValue({ args0 -> args0 }))
            .pidLoopIsCrucial(pidLoopIsCrucial?.applyValue({ args0 -> args0 }))
            .pidLoopName(pidLoopName?.applyValue({ args0 -> args0 }))
            .pidLoopType(pidLoopType?.applyValue({ args0 -> args0 }))
            .pidProjectId(pidProjectId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndustrialPidLoopArgs].
 */
@PulumiTagMarker
public class IndustrialPidLoopArgsBuilder internal constructor() {
    private var pidLoopConfiguration: Output<String>? = null

    private var pidLoopDcsType: Output<String>? = null

    private var pidLoopDesc: Output<String>? = null

    private var pidLoopIsCrucial: Output<Boolean>? = null

    private var pidLoopName: Output<String>? = null

    private var pidLoopType: Output<String>? = null

    private var pidProjectId: Output<String>? = null

    /**
     * @param value The Pid Loop Configuration.
     */
    @JvmName("rughxjekhqttoieb")
    public suspend fun pidLoopConfiguration(`value`: Output<String>) {
        this.pidLoopConfiguration = value
    }

    /**
     * @param value The dcs type of Pid Loop. Valid values: `standard`.
     */
    @JvmName("yvcorpgxwvjlvdfk")
    public suspend fun pidLoopDcsType(`value`: Output<String>) {
        this.pidLoopDcsType = value
    }

    /**
     * @param value The desc of Pid Loop.
     */
    @JvmName("kbcbfnteihlwlcse")
    public suspend fun pidLoopDesc(`value`: Output<String>) {
        this.pidLoopDesc = value
    }

    /**
     * @param value Whether is crucial Pid Loop.
     */
    @JvmName("bpstdtaevykasycc")
    public suspend fun pidLoopIsCrucial(`value`: Output<Boolean>) {
        this.pidLoopIsCrucial = value
    }

    /**
     * @param value The name of Pid Loop.
     */
    @JvmName("ulkdtwanedofbjpr")
    public suspend fun pidLoopName(`value`: Output<String>) {
        this.pidLoopName = value
    }

    /**
     * @param value The type of Pid Loop. Valid values: `0`, `1`, `2`, `3`, `4`, `5`.
     */
    @JvmName("iexjpgkeeelxaoys")
    public suspend fun pidLoopType(`value`: Output<String>) {
        this.pidLoopType = value
    }

    /**
     * @param value The pid project id.
     */
    @JvmName("utqukflpksbhodmr")
    public suspend fun pidProjectId(`value`: Output<String>) {
        this.pidProjectId = value
    }

    /**
     * @param value The Pid Loop Configuration.
     */
    @JvmName("fkutdrdiedpwoodf")
    public suspend fun pidLoopConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidLoopConfiguration = mapped
    }

    /**
     * @param value The dcs type of Pid Loop. Valid values: `standard`.
     */
    @JvmName("lxcrofhvqgbnvlfg")
    public suspend fun pidLoopDcsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidLoopDcsType = mapped
    }

    /**
     * @param value The desc of Pid Loop.
     */
    @JvmName("wbfhtnfhvcmbiwig")
    public suspend fun pidLoopDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidLoopDesc = mapped
    }

    /**
     * @param value Whether is crucial Pid Loop.
     */
    @JvmName("vnibxcnitqhjakji")
    public suspend fun pidLoopIsCrucial(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidLoopIsCrucial = mapped
    }

    /**
     * @param value The name of Pid Loop.
     */
    @JvmName("tqlwpjqsvdtmpvxo")
    public suspend fun pidLoopName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidLoopName = mapped
    }

    /**
     * @param value The type of Pid Loop. Valid values: `0`, `1`, `2`, `3`, `4`, `5`.
     */
    @JvmName("dmrfnlejstulbexs")
    public suspend fun pidLoopType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidLoopType = mapped
    }

    /**
     * @param value The pid project id.
     */
    @JvmName("tmcicsnceauxsfdu")
    public suspend fun pidProjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidProjectId = mapped
    }

    internal fun build(): IndustrialPidLoopArgs = IndustrialPidLoopArgs(
        pidLoopConfiguration = pidLoopConfiguration,
        pidLoopDcsType = pidLoopDcsType,
        pidLoopDesc = pidLoopDesc,
        pidLoopIsCrucial = pidLoopIsCrucial,
        pidLoopName = pidLoopName,
        pidLoopType = pidLoopType,
        pidProjectId = pidProjectId,
    )
}
