@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IndustrialPidOrganization].
 */
@PulumiTagMarker
public class IndustrialPidOrganizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndustrialPidOrganizationArgs = IndustrialPidOrganizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndustrialPidOrganizationArgsBuilder.() -> Unit) {
        val builder = IndustrialPidOrganizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IndustrialPidOrganization {
        val builtJavaResource =
            com.pulumi.alicloud.brain.IndustrialPidOrganization(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IndustrialPidOrganization(builtJavaResource)
    }
}

/**
 * Provides a Brain Industrial Pid Organization resource.
 * > **NOTE:** Available in v1.113.0+.
 * > **DEPRECATED:**  This resource has been from version `1.222.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.brain.IndustrialPidOrganization("example", {pidOrganizationName: "tf-testAcc"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.brain.IndustrialPidOrganization("example", pid_organization_name="tf-testAcc")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Brain.IndustrialPidOrganization("example", new()
 *     {
 *         PidOrganizationName = "tf-testAcc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := brain.NewIndustrialPidOrganization(ctx, "example", &brain.IndustrialPidOrganizationArgs{
 * 			PidOrganizationName: pulumi.String("tf-testAcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.brain.IndustrialPidOrganization;
 * import com.pulumi.alicloud.brain.IndustrialPidOrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndustrialPidOrganization("example", IndustrialPidOrganizationArgs.builder()
 *             .pidOrganizationName("tf-testAcc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:brain:IndustrialPidOrganization
 *     properties:
 *       pidOrganizationName: tf-testAcc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Brain Industrial Pid Organization can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:brain/industrialPidOrganization:IndustrialPidOrganization example <id>
 * ```
 */
public class IndustrialPidOrganization internal constructor(
    override val javaResource: com.pulumi.alicloud.brain.IndustrialPidOrganization,
) : KotlinCustomResource(javaResource, IndustrialPidOrganizationMapper) {
    /**
     * The ID of parent pid organization.
     */
    public val parentPidOrganizationId: Output<String>?
        get() = javaResource.parentPidOrganizationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of pid organization.
     */
    public val pidOrganizationName: Output<String>
        get() = javaResource.pidOrganizationName().applyValue({ args0 -> args0 })
}

public object IndustrialPidOrganizationMapper : ResourceMapper<IndustrialPidOrganization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.brain.IndustrialPidOrganization::class == javaResource::class

    override fun map(javaResource: Resource): IndustrialPidOrganization =
        IndustrialPidOrganization(javaResource as com.pulumi.alicloud.brain.IndustrialPidOrganization)
}

/**
 * @see [IndustrialPidOrganization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IndustrialPidOrganization].
 */
public suspend fun industrialPidOrganization(
    name: String,
    block: suspend IndustrialPidOrganizationResourceBuilder.() -> Unit,
): IndustrialPidOrganization {
    val builder = IndustrialPidOrganizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IndustrialPidOrganization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun industrialPidOrganization(name: String): IndustrialPidOrganization {
    val builder = IndustrialPidOrganizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
