@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.alicloud.brain.IndustrialPidOrganizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Brain Industrial Pid Organization resource.
 * > **NOTE:** Available in v1.113.0+.
 * > **DEPRECATED:**  This resource has been from version `1.222.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.brain.IndustrialPidOrganization("example", {pidOrganizationName: "tf-testAcc"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.brain.IndustrialPidOrganization("example", pid_organization_name="tf-testAcc")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Brain.IndustrialPidOrganization("example", new()
 *     {
 *         PidOrganizationName = "tf-testAcc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := brain.NewIndustrialPidOrganization(ctx, "example", &brain.IndustrialPidOrganizationArgs{
 * 			PidOrganizationName: pulumi.String("tf-testAcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.brain.IndustrialPidOrganization;
 * import com.pulumi.alicloud.brain.IndustrialPidOrganizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndustrialPidOrganization("example", IndustrialPidOrganizationArgs.builder()
 *             .pidOrganizationName("tf-testAcc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:brain:IndustrialPidOrganization
 *     properties:
 *       pidOrganizationName: tf-testAcc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Brain Industrial Pid Organization can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:brain/industrialPidOrganization:IndustrialPidOrganization example <id>
 * ```
 * @property parentPidOrganizationId The ID of parent pid organization.
 * @property pidOrganizationName The name of pid organization.
 */
public data class IndustrialPidOrganizationArgs(
    public val parentPidOrganizationId: Output<String>? = null,
    public val pidOrganizationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.IndustrialPidOrganizationArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.IndustrialPidOrganizationArgs =
        com.pulumi.alicloud.brain.IndustrialPidOrganizationArgs.builder()
            .parentPidOrganizationId(parentPidOrganizationId?.applyValue({ args0 -> args0 }))
            .pidOrganizationName(pidOrganizationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndustrialPidOrganizationArgs].
 */
@PulumiTagMarker
public class IndustrialPidOrganizationArgsBuilder internal constructor() {
    private var parentPidOrganizationId: Output<String>? = null

    private var pidOrganizationName: Output<String>? = null

    /**
     * @param value The ID of parent pid organization.
     */
    @JvmName("tougceiuxcqhcixo")
    public suspend fun parentPidOrganizationId(`value`: Output<String>) {
        this.parentPidOrganizationId = value
    }

    /**
     * @param value The name of pid organization.
     */
    @JvmName("mddktkghsnsxhgmk")
    public suspend fun pidOrganizationName(`value`: Output<String>) {
        this.pidOrganizationName = value
    }

    /**
     * @param value The ID of parent pid organization.
     */
    @JvmName("otimddornnwlufti")
    public suspend fun parentPidOrganizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentPidOrganizationId = mapped
    }

    /**
     * @param value The name of pid organization.
     */
    @JvmName("exonpocskpvglsdf")
    public suspend fun pidOrganizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidOrganizationName = mapped
    }

    internal fun build(): IndustrialPidOrganizationArgs = IndustrialPidOrganizationArgs(
        parentPidOrganizationId = parentPidOrganizationId,
        pidOrganizationName = pidOrganizationName,
    )
}
