@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IndustrialPidProject].
 */
@PulumiTagMarker
public class IndustrialPidProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IndustrialPidProjectArgs = IndustrialPidProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IndustrialPidProjectArgsBuilder.() -> Unit) {
        val builder = IndustrialPidProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IndustrialPidProject {
        val builtJavaResource = com.pulumi.alicloud.brain.IndustrialPidProject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IndustrialPidProject(builtJavaResource)
    }
}

/**
 * Provides a Brain Industrial Pid Project resource.
 * > **NOTE:** Available in v1.113.0+.
 * > **DEPRECATED:**  This resource has been from version `1.222.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.brain.IndustrialPidProject("example", {
 *     pidOrganizationId: "3e74e684-cbb5-xxxx",
 *     pidProjectName: "tf-testAcc",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.brain.IndustrialPidProject("example",
 *     pid_organization_id="3e74e684-cbb5-xxxx",
 *     pid_project_name="tf-testAcc")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Brain.IndustrialPidProject("example", new()
 *     {
 *         PidOrganizationId = "3e74e684-cbb5-xxxx",
 *         PidProjectName = "tf-testAcc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := brain.NewIndustrialPidProject(ctx, "example", &brain.IndustrialPidProjectArgs{
 * 			PidOrganizationId: pulumi.String("3e74e684-cbb5-xxxx"),
 * 			PidProjectName:    pulumi.String("tf-testAcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.brain.IndustrialPidProject;
 * import com.pulumi.alicloud.brain.IndustrialPidProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndustrialPidProject("example", IndustrialPidProjectArgs.builder()
 *             .pidOrganizationId("3e74e684-cbb5-xxxx")
 *             .pidProjectName("tf-testAcc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:brain:IndustrialPidProject
 *     properties:
 *       pidOrganizationId: 3e74e684-cbb5-xxxx
 *       pidProjectName: tf-testAcc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Brain Industrial Pid Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:brain/industrialPidProject:IndustrialPidProject example <id>
 * ```
 */
public class IndustrialPidProject internal constructor(
    override val javaResource: com.pulumi.alicloud.brain.IndustrialPidProject,
) : KotlinCustomResource(javaResource, IndustrialPidProjectMapper) {
    /**
     * The ID of Pid Organization.
     */
    public val pidOrganizationId: Output<String>
        get() = javaResource.pidOrganizationId().applyValue({ args0 -> args0 })

    /**
     * The description of Pid Project.
     */
    public val pidProjectDesc: Output<String>?
        get() = javaResource.pidProjectDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of Pid Project.
     */
    public val pidProjectName: Output<String>
        get() = javaResource.pidProjectName().applyValue({ args0 -> args0 })
}

public object IndustrialPidProjectMapper : ResourceMapper<IndustrialPidProject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.brain.IndustrialPidProject::class == javaResource::class

    override fun map(javaResource: Resource): IndustrialPidProject = IndustrialPidProject(
        javaResource
            as com.pulumi.alicloud.brain.IndustrialPidProject,
    )
}

/**
 * @see [IndustrialPidProject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IndustrialPidProject].
 */
public suspend fun industrialPidProject(
    name: String,
    block: suspend IndustrialPidProjectResourceBuilder.() -> Unit,
): IndustrialPidProject {
    val builder = IndustrialPidProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IndustrialPidProject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun industrialPidProject(name: String): IndustrialPidProject {
    val builder = IndustrialPidProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
