@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin

import com.pulumi.alicloud.brain.IndustrialPidProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Brain Industrial Pid Project resource.
 * > **NOTE:** Available in v1.113.0+.
 * > **DEPRECATED:**  This resource has been from version `1.222.0`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.brain.IndustrialPidProject("example", {
 *     pidOrganizationId: "3e74e684-cbb5-xxxx",
 *     pidProjectName: "tf-testAcc",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.brain.IndustrialPidProject("example",
 *     pid_organization_id="3e74e684-cbb5-xxxx",
 *     pid_project_name="tf-testAcc")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Brain.IndustrialPidProject("example", new()
 *     {
 *         PidOrganizationId = "3e74e684-cbb5-xxxx",
 *         PidProjectName = "tf-testAcc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/brain"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := brain.NewIndustrialPidProject(ctx, "example", &brain.IndustrialPidProjectArgs{
 * 			PidOrganizationId: pulumi.String("3e74e684-cbb5-xxxx"),
 * 			PidProjectName:    pulumi.String("tf-testAcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.brain.IndustrialPidProject;
 * import com.pulumi.alicloud.brain.IndustrialPidProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IndustrialPidProject("example", IndustrialPidProjectArgs.builder()
 *             .pidOrganizationId("3e74e684-cbb5-xxxx")
 *             .pidProjectName("tf-testAcc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:brain:IndustrialPidProject
 *     properties:
 *       pidOrganizationId: 3e74e684-cbb5-xxxx
 *       pidProjectName: tf-testAcc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Brain Industrial Pid Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:brain/industrialPidProject:IndustrialPidProject example <id>
 * ```
 * @property pidOrganizationId The ID of Pid Organization.
 * @property pidProjectDesc The description of Pid Project.
 * @property pidProjectName The name of Pid Project.
 */
public data class IndustrialPidProjectArgs(
    public val pidOrganizationId: Output<String>? = null,
    public val pidProjectDesc: Output<String>? = null,
    public val pidProjectName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.IndustrialPidProjectArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.IndustrialPidProjectArgs =
        com.pulumi.alicloud.brain.IndustrialPidProjectArgs.builder()
            .pidOrganizationId(pidOrganizationId?.applyValue({ args0 -> args0 }))
            .pidProjectDesc(pidProjectDesc?.applyValue({ args0 -> args0 }))
            .pidProjectName(pidProjectName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IndustrialPidProjectArgs].
 */
@PulumiTagMarker
public class IndustrialPidProjectArgsBuilder internal constructor() {
    private var pidOrganizationId: Output<String>? = null

    private var pidProjectDesc: Output<String>? = null

    private var pidProjectName: Output<String>? = null

    /**
     * @param value The ID of Pid Organization.
     */
    @JvmName("aaenprdmsjtkcadm")
    public suspend fun pidOrganizationId(`value`: Output<String>) {
        this.pidOrganizationId = value
    }

    /**
     * @param value The description of Pid Project.
     */
    @JvmName("apnnmmdcmbdmqnev")
    public suspend fun pidProjectDesc(`value`: Output<String>) {
        this.pidProjectDesc = value
    }

    /**
     * @param value The name of Pid Project.
     */
    @JvmName("shnnachtwpurkemo")
    public suspend fun pidProjectName(`value`: Output<String>) {
        this.pidProjectName = value
    }

    /**
     * @param value The ID of Pid Organization.
     */
    @JvmName("uvowfuibopwrlcgd")
    public suspend fun pidOrganizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidOrganizationId = mapped
    }

    /**
     * @param value The description of Pid Project.
     */
    @JvmName("pclmosmgespmshjr")
    public suspend fun pidProjectDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidProjectDesc = mapped
    }

    /**
     * @param value The name of Pid Project.
     */
    @JvmName("dswhrypdbcgtktpm")
    public suspend fun pidProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pidProjectName = mapped
    }

    internal fun build(): IndustrialPidProjectArgs = IndustrialPidProjectArgs(
        pidOrganizationId = pidOrganizationId,
        pidProjectDesc = pidProjectDesc,
        pidProjectName = pidProjectName,
    )
}
