@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.inputs

import com.pulumi.alicloud.brain.inputs.GetIndustrialPidLoopsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIndustrialPidLoops.
 * @property enableDetails
 * @property ids A list of Pid Loop IDs.
 * @property nameRegex A regex string to filter results by Pid Loop name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pidLoopName The name of Pid Loop.
 * @property pidProjectId The pid project id.
 * @property status The status of Pid Loop.
 */
public data class GetIndustrialPidLoopsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pidLoopName: String? = null,
    public val pidProjectId: String,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.inputs.GetIndustrialPidLoopsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.inputs.GetIndustrialPidLoopsPlainArgs =
        com.pulumi.alicloud.brain.inputs.GetIndustrialPidLoopsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pidLoopName(pidLoopName?.let({ args0 -> args0 }))
            .pidProjectId(pidProjectId.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIndustrialPidLoopsPlainArgs].
 */
@PulumiTagMarker
public class GetIndustrialPidLoopsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pidLoopName: String? = null

    private var pidProjectId: String? = null

    private var status: String? = null

    /**
     * @param value
     */
    @JvmName("hcitdqxsnxmjyewl")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Pid Loop IDs.
     */
    @JvmName("efomqgxrovfmdfsf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Pid Loop IDs.
     */
    @JvmName("isbiyrdikuslshse")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Pid Loop name.
     */
    @JvmName("bmrjgcpgcbmkfmdn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("adrlhrunmobiekgd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of Pid Loop.
     */
    @JvmName("fnetsdsoollufrcg")
    public suspend fun pidLoopName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pidLoopName = mapped
    }

    /**
     * @param value The pid project id.
     */
    @JvmName("dauirfmqakgdipku")
    public suspend fun pidProjectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pidProjectId = mapped
    }

    /**
     * @param value The status of Pid Loop.
     */
    @JvmName("pnbsmmptmbyytwkr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetIndustrialPidLoopsPlainArgs = GetIndustrialPidLoopsPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pidLoopName = pidLoopName,
        pidProjectId = pidProjectId ?: throw PulumiNullFieldException("pidProjectId"),
        status = status,
    )
}
