@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.inputs

import com.pulumi.alicloud.brain.inputs.GetIndustrialPidOrganizationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIndustrialPidOrganizations.
 * @property ids A list of Pid Organization IDs.
 * @property nameRegex A regex string to filter results by Pid Organization name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property parentOrganizationId The parent organization id.
 */
public data class GetIndustrialPidOrganizationsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val parentOrganizationId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.inputs.GetIndustrialPidOrganizationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.inputs.GetIndustrialPidOrganizationsPlainArgs =
        com.pulumi.alicloud.brain.inputs.GetIndustrialPidOrganizationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .parentOrganizationId(parentOrganizationId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIndustrialPidOrganizationsPlainArgs].
 */
@PulumiTagMarker
public class GetIndustrialPidOrganizationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var parentOrganizationId: String? = null

    /**
     * @param value A list of Pid Organization IDs.
     */
    @JvmName("iggogfophvxxpqcn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Pid Organization IDs.
     */
    @JvmName("bijjgrsdtbuhjpcg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Pid Organization name.
     */
    @JvmName("ytnakaxwiqcvwlsx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qvxtxxucwpxyyunw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The parent organization id.
     */
    @JvmName("yymuebcuhmpqvxsf")
    public suspend fun parentOrganizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parentOrganizationId = mapped
    }

    internal fun build(): GetIndustrialPidOrganizationsPlainArgs =
        GetIndustrialPidOrganizationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            parentOrganizationId = parentOrganizationId,
        )
}
