@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.inputs

import com.pulumi.alicloud.brain.inputs.GetIndustrialPidProjectsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIndustrialPidProjects.
 * @property ids A list of Pid Project IDs.
 * @property nameRegex A regex string to filter results by Pid Project name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pidOrganizationId The ID of Pid Organization.
 * @property pidProjectName The name of Pid Project.
 */
public data class GetIndustrialPidProjectsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pidOrganizationId: String? = null,
    public val pidProjectName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.inputs.GetIndustrialPidProjectsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.inputs.GetIndustrialPidProjectsPlainArgs =
        com.pulumi.alicloud.brain.inputs.GetIndustrialPidProjectsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pidOrganizationId(pidOrganizationId?.let({ args0 -> args0 }))
            .pidProjectName(pidProjectName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIndustrialPidProjectsPlainArgs].
 */
@PulumiTagMarker
public class GetIndustrialPidProjectsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pidOrganizationId: String? = null

    private var pidProjectName: String? = null

    /**
     * @param value A list of Pid Project IDs.
     */
    @JvmName("hqqdomahsgtdigbl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Pid Project IDs.
     */
    @JvmName("blcynwrahoyvpxmh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Pid Project name.
     */
    @JvmName("yblfmwlujacinheb")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lyrejxsmyecylfji")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of Pid Organization.
     */
    @JvmName("tvqpendvdtjwrjkg")
    public suspend fun pidOrganizationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pidOrganizationId = mapped
    }

    /**
     * @param value The name of Pid Project.
     */
    @JvmName("dtbtffqjynndargo")
    public suspend fun pidProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pidProjectName = mapped
    }

    internal fun build(): GetIndustrialPidProjectsPlainArgs = GetIndustrialPidProjectsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pidOrganizationId = pidOrganizationId,
        pidProjectName = pidProjectName,
    )
}
