@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.inputs

import com.pulumi.alicloud.brain.inputs.GetIndustrialSericePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIndustrialSerice.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
 * > **NOTE:** Setting `enable = "On"` to open the Brain Industrial service. The service can not closed once it is opened.
 */
public data class GetIndustrialSericePlainArgs(
    public val enable: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.brain.inputs.GetIndustrialSericePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.brain.inputs.GetIndustrialSericePlainArgs =
        com.pulumi.alicloud.brain.inputs.GetIndustrialSericePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIndustrialSericePlainArgs].
 */
@PulumiTagMarker
public class GetIndustrialSericePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Brain Industrial service. The service can not closed once it is opened.
     */
    @JvmName("jtpgtjxmyykfpaoj")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetIndustrialSericePlainArgs = GetIndustrialSericePlainArgs(
        enable = enable,
    )
}
