@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Pid Loop.
 * @property pidLoopConfiguration
 * @property pidLoopDcsType The dcs type of Pid Loop.
 * @property pidLoopDesc
 * @property pidLoopId The ID of the Pid Loop.
 * @property pidLoopIsCrucial Whether is crucial Pid Loop.
 * @property pidLoopName The name of Pid Loop.
 * @property pidLoopType The type of Pid Loop.
 * @property pidProjectId The pid project id.
 * @property status The status of Pid Loop.
 */
public data class GetIndustrialPidLoopsLoop(
    public val id: String,
    public val pidLoopConfiguration: String,
    public val pidLoopDcsType: String,
    public val pidLoopDesc: String,
    public val pidLoopId: String,
    public val pidLoopIsCrucial: Boolean,
    public val pidLoopName: String,
    public val pidLoopType: String,
    public val pidProjectId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.brain.outputs.GetIndustrialPidLoopsLoop): GetIndustrialPidLoopsLoop = GetIndustrialPidLoopsLoop(
            id = javaType.id(),
            pidLoopConfiguration = javaType.pidLoopConfiguration(),
            pidLoopDcsType = javaType.pidLoopDcsType(),
            pidLoopDesc = javaType.pidLoopDesc(),
            pidLoopId = javaType.pidLoopId(),
            pidLoopIsCrucial = javaType.pidLoopIsCrucial(),
            pidLoopName = javaType.pidLoopName(),
            pidLoopType = javaType.pidLoopType(),
            pidProjectId = javaType.pidProjectId(),
            status = javaType.status(),
        )
    }
}
