@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIndustrialPidLoops.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property loops
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pidLoopName
 * @property pidProjectId
 * @property status
 */
public data class GetIndustrialPidLoopsResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val loops: List<GetIndustrialPidLoopsLoop>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pidLoopName: String? = null,
    public val pidProjectId: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.brain.outputs.GetIndustrialPidLoopsResult): GetIndustrialPidLoopsResult = GetIndustrialPidLoopsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            loops = javaType.loops().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidLoopsLoop.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pidLoopName = javaType.pidLoopName().map({ args0 -> args0 }).orElse(null),
            pidProjectId = javaType.pidProjectId(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
