@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIndustrialPidOrganizations.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property organizations
 * @property outputFile
 * @property parentOrganizationId
 */
public data class GetIndustrialPidOrganizationsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val organizations: List<GetIndustrialPidOrganizationsOrganization>,
    public val outputFile: String? = null,
    public val parentOrganizationId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.brain.outputs.GetIndustrialPidOrganizationsResult): GetIndustrialPidOrganizationsResult = GetIndustrialPidOrganizationsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            organizations = javaType.organizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidOrganizationsOrganization.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            parentOrganizationId = javaType.parentOrganizationId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
