@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.brain.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIndustrialPidProjects.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pidOrganizationId
 * @property pidProjectName
 * @property projects
 */
public data class GetIndustrialPidProjectsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pidOrganizationId: String? = null,
    public val pidProjectName: String? = null,
    public val projects: List<GetIndustrialPidProjectsProject>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.brain.outputs.GetIndustrialPidProjectsResult): GetIndustrialPidProjectsResult = GetIndustrialPidProjectsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pidOrganizationId = javaType.pidOrganizationId().map({ args0 -> args0 }).orElse(null),
            pidProjectName = javaType.pidProjectName().map({ args0 -> args0 }).orElse(null),
            projects = javaType.projects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.brain.kotlin.outputs.GetIndustrialPidProjectsProject.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
