@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin

import com.pulumi.alicloud.bss.BssFunctions.getOpenApiPricingModulesPlain
import com.pulumi.alicloud.bss.BssFunctions.getOpenApiProductsPlain
import com.pulumi.alicloud.bss.kotlin.inputs.GetOpenApiPricingModulesPlainArgs
import com.pulumi.alicloud.bss.kotlin.inputs.GetOpenApiPricingModulesPlainArgsBuilder
import com.pulumi.alicloud.bss.kotlin.inputs.GetOpenApiProductsPlainArgs
import com.pulumi.alicloud.bss.kotlin.inputs.GetOpenApiProductsPlainArgsBuilder
import com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiPricingModulesResult
import com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiProductsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiPricingModulesResult.Companion.toKotlin as getOpenApiPricingModulesResultToKotlin
import com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiProductsResult.Companion.toKotlin as getOpenApiProductsResultToKotlin

public object BssFunctions {
    /**
     * This data source provides Bss Open Api Pricing Module available to the user.[What is Pricing Module](https://www.alibabacloud.com/help/en/bss-openapi/latest/describepricingmodule#doc-api-BssOpenApi-DescribePricingModule)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.bss.getOpenApiPricingModules({
     *     nameRegex: "国内月均日峰值带宽",
     *     productCode: "cdn",
     *     productType: "CDN",
     *     subscriptionType: "PayAsYouGo",
     * });
     * export const alicloudBssOpenapiPricingModuleExampleId = _default.then(_default => _default.modules?.[0]?.code);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.bss.get_open_api_pricing_modules(name_regex="国内月均日峰值带宽",
     *     product_code="cdn",
     *     product_type="CDN",
     *     subscription_type="PayAsYouGo")
     * pulumi.export("alicloudBssOpenapiPricingModuleExampleId", default.modules[0].code)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Bss.GetOpenApiPricingModules.Invoke(new()
     *     {
     *         NameRegex = "国内月均日峰值带宽",
     *         ProductCode = "cdn",
     *         ProductType = "CDN",
     *         SubscriptionType = "PayAsYouGo",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudBssOpenapiPricingModuleExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getOpenApiPricingModulesResult => getOpenApiPricingModulesResult&#46;Modules[0]?.Code)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/bss"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := bss.GetOpenApiPricingModules(ctx, &bss.GetOpenApiPricingModulesArgs{
     * 			NameRegex:        pulumi.StringRef("国内月均日峰值带宽"),
     * 			ProductCode:      "cdn",
     * 			ProductType:      pulumi.StringRef("CDN"),
     * 			SubscriptionType: "PayAsYouGo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudBssOpenapiPricingModuleExampleId", _default.Modules[0].Code)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.bss.BssFunctions;
     * import com.pulumi.alicloud.bss.inputs.GetOpenApiPricingModulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = BssFunctions.getOpenApiPricingModules(GetOpenApiPricingModulesArgs.builder()
     *             .nameRegex("国内月均日峰值带宽")
     *             .productCode("cdn")
     *             .productType("CDN")
     *             .subscriptionType("PayAsYouGo")
     *             .build());
     *         ctx.export("alicloudBssOpenapiPricingModuleExampleId", default_.modules()[0].code());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:bss:getOpenApiPricingModules
     *       Arguments:
     *         nameRegex: 国内月均日峰值带宽
     *         productCode: cdn
     *         productType: CDN
     *         subscriptionType: PayAsYouGo
     * outputs:
     *   alicloudBssOpenapiPricingModuleExampleId: ${default.modules[0].code}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOpenApiPricingModules.
     * @return A collection of values returned by getOpenApiPricingModules.
     */
    public suspend fun getOpenApiPricingModules(argument: GetOpenApiPricingModulesPlainArgs): GetOpenApiPricingModulesResult =
        getOpenApiPricingModulesResultToKotlin(getOpenApiPricingModulesPlain(argument.toJava()).await())

    /**
     * @see [getOpenApiPricingModules].
     * @param ids
     * @param nameRegex A regex string to filter results by Property name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param productCode The product code.
     * @param productType The product type.
     * @param subscriptionType Subscription type. Value:
     * * Subscription: Prepaid.
     * * PayAsYouGo: postpaid.
     * @return A collection of values returned by getOpenApiPricingModules.
     */
    public suspend fun getOpenApiPricingModules(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        productCode: String,
        productType: String? = null,
        subscriptionType: String,
    ): GetOpenApiPricingModulesResult {
        val argument = GetOpenApiPricingModulesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            productCode = productCode,
            productType = productType,
            subscriptionType = subscriptionType,
        )
        return getOpenApiPricingModulesResultToKotlin(getOpenApiPricingModulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenApiPricingModules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bss&#46;kotlin&#46;inputs&#46;GetOpenApiPricingModulesPlainArgs].
     * @return A collection of values returned by getOpenApiPricingModules.
     */
    public suspend fun getOpenApiPricingModules(argument: suspend GetOpenApiPricingModulesPlainArgsBuilder.() -> Unit): GetOpenApiPricingModulesResult {
        val builder = GetOpenApiPricingModulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenApiPricingModulesResultToKotlin(getOpenApiPricingModulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Bss Open Api Product available to the user.[What is Product](https://www.alibabacloud.com/help/en/bss-openapi/latest/api-bssopenapi-2017-12-14-queryproductlist)
     * > **NOTE:** Available in 1.195.0+
     * @param argument A collection of arguments for invoking getOpenApiProducts.
     * @return A collection of values returned by getOpenApiProducts.
     */
    public suspend fun getOpenApiProducts(argument: GetOpenApiProductsPlainArgs): GetOpenApiProductsResult =
        getOpenApiProductsResultToKotlin(getOpenApiProductsPlain(argument.toJava()).await())

    /**
     * @see [getOpenApiProducts].
     * @param ids A list of product IDs.
     * @param nameRegex A regex string to filter results by Product name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getOpenApiProducts.
     */
    public suspend fun getOpenApiProducts(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetOpenApiProductsResult {
        val argument = GetOpenApiProductsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getOpenApiProductsResultToKotlin(getOpenApiProductsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenApiProducts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;bss&#46;kotlin&#46;inputs&#46;GetOpenApiProductsPlainArgs].
     * @return A collection of values returned by getOpenApiProducts.
     */
    public suspend fun getOpenApiProducts(argument: suspend GetOpenApiProductsPlainArgsBuilder.() -> Unit): GetOpenApiProductsResult {
        val builder = GetOpenApiProductsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenApiProductsResultToKotlin(getOpenApiProductsPlain(builtArgument.toJava()).await())
    }
}
