@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.inputs

import com.pulumi.alicloud.bss.inputs.GetOpenApiPricingModulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOpenApiPricingModules.
 * @property ids
 * @property nameRegex A regex string to filter results by Property name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property productCode The product code.
 * @property productType The product type.
 * @property subscriptionType Subscription type. Value:
 * * Subscription: Prepaid.
 * * PayAsYouGo: postpaid.
 */
public data class GetOpenApiPricingModulesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val productCode: String,
    public val productType: String? = null,
    public val subscriptionType: String,
) : ConvertibleToJava<com.pulumi.alicloud.bss.inputs.GetOpenApiPricingModulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bss.inputs.GetOpenApiPricingModulesPlainArgs =
        com.pulumi.alicloud.bss.inputs.GetOpenApiPricingModulesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .productCode(productCode.let({ args0 -> args0 }))
            .productType(productType?.let({ args0 -> args0 }))
            .subscriptionType(subscriptionType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOpenApiPricingModulesPlainArgs].
 */
@PulumiTagMarker
public class GetOpenApiPricingModulesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var productCode: String? = null

    private var productType: String? = null

    private var subscriptionType: String? = null

    /**
     * @param value
     */
    @JvmName("kirgbirahnqtlswy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("matjfjphlwiyudke")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Property name.
     */
    @JvmName("qqvsyubaglpvvgmv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("cvdohpgfasgywwmd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The product code.
     */
    @JvmName("ujfbcjswoedqcmks")
    public suspend fun productCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productCode = mapped
    }

    /**
     * @param value The product type.
     */
    @JvmName("jcicyrlgmwgxitlb")
    public suspend fun productType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productType = mapped
    }

    /**
     * @param value Subscription type. Value:
     * * Subscription: Prepaid.
     * * PayAsYouGo: postpaid.
     */
    @JvmName("sbdwfpsfgnofbyol")
    public suspend fun subscriptionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subscriptionType = mapped
    }

    internal fun build(): GetOpenApiPricingModulesPlainArgs = GetOpenApiPricingModulesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        productCode = productCode ?: throw PulumiNullFieldException("productCode"),
        productType = productType,
        subscriptionType = subscriptionType ?: throw PulumiNullFieldException("subscriptionType"),
    )
}
