@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.inputs

import com.pulumi.alicloud.bss.inputs.GetOpenApiProductsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOpenApiProducts.
 * @property ids A list of product IDs.
 * @property nameRegex A regex string to filter results by Product name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetOpenApiProductsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.bss.inputs.GetOpenApiProductsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.bss.inputs.GetOpenApiProductsPlainArgs =
        com.pulumi.alicloud.bss.inputs.GetOpenApiProductsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOpenApiProductsPlainArgs].
 */
@PulumiTagMarker
public class GetOpenApiProductsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of product IDs.
     */
    @JvmName("opjbwjhpjogkenao")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of product IDs.
     */
    @JvmName("gygivhmhcmbntuos")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Product name.
     */
    @JvmName("bqdrluloywcclqjv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("omclqoxamfmeuxkp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetOpenApiProductsPlainArgs = GetOpenApiProductsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
