@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property code Property Code.
 * @property id A list of Price Module IDs.
 * @property pricingModuleName Attribute name.
 * @property productCode The product code.
 * @property productType The product type.
 * @property subscriptionType Subscription type. Value:
 * * Subscription: Prepaid.
 * * PayAsYouGo: postpaid.
 * @property unit Attribute unit.
 * @property values Property.
 */
public data class GetOpenApiPricingModulesModule(
    public val code: String,
    public val id: String,
    public val pricingModuleName: String,
    public val productCode: String,
    public val productType: String,
    public val subscriptionType: String,
    public val unit: String,
    public val values: List<GetOpenApiPricingModulesModuleValue>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bss.outputs.GetOpenApiPricingModulesModule): GetOpenApiPricingModulesModule = GetOpenApiPricingModulesModule(
            code = javaType.code(),
            id = javaType.id(),
            pricingModuleName = javaType.pricingModuleName(),
            productCode = javaType.productCode(),
            productType = javaType.productType(),
            subscriptionType = javaType.subscriptionType(),
            unit = javaType.unit(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiPricingModulesModuleValue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
