@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The module Code corresponds to the attribute value.
 * @property remark Module value description information.
 * @property type The attribute value type corresponding to the module Code. Value:
 * * single_float: single value type.
 * * range_float: range value type.
 * @property value The module Code corresponds to the attribute value.
 * > format 1024-1024000 when Type = range_float: 1024 means from 1024 to 1024000, step size 1024.
 */
public data class GetOpenApiPricingModulesModuleValue(
    public val name: String,
    public val remark: String,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bss.outputs.GetOpenApiPricingModulesModuleValue): GetOpenApiPricingModulesModuleValue = GetOpenApiPricingModulesModuleValue(
            name = javaType.name(),
            remark = javaType.remark(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
