@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOpenApiPricingModules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property modules A list of Pricing Module Entries. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of name of Pricing Modules.
 * @property outputFile
 * @property productCode
 * @property productType
 * @property subscriptionType
 */
public data class GetOpenApiPricingModulesResult(
    public val id: String,
    public val ids: List<String>,
    public val modules: List<GetOpenApiPricingModulesModule>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val productCode: String,
    public val productType: String? = null,
    public val subscriptionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bss.outputs.GetOpenApiPricingModulesResult): GetOpenApiPricingModulesResult = GetOpenApiPricingModulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            modules = javaType.modules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiPricingModulesModule.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            productCode = javaType.productCode(),
            productType = javaType.productType().map({ args0 -> args0 }).orElse(null),
            subscriptionType = javaType.subscriptionType(),
        )
    }
}
