@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the product. The value is formulated as `<product_code>:<product_type>:<subscription_type>`.
 * @property productCode Product code.
 * @property productName Product name.
 * @property productType Type of product.
 * @property subscriptionType Subscription type. Value:
 * * Subscription: Prepaid.
 * * PayAsYouGo: postpaid.
 */
public data class GetOpenApiProductsProduct(
    public val id: String,
    public val productCode: String,
    public val productName: String,
    public val productType: String,
    public val subscriptionType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bss.outputs.GetOpenApiProductsProduct): GetOpenApiProductsProduct = GetOpenApiProductsProduct(
            id = javaType.id(),
            productCode = javaType.productCode(),
            productName = javaType.productName(),
            productType = javaType.productType(),
            subscriptionType = javaType.subscriptionType(),
        )
    }
}
