@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.bss.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOpenApiProducts.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of name of Products.
 * @property outputFile
 * @property products A list of Product Entries. Each element contains the following attributes:
 */
public data class GetOpenApiProductsResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val products: List<GetOpenApiProductsProduct>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.bss.outputs.GetOpenApiProductsResult): GetOpenApiProductsResult = GetOpenApiProductsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            products = javaType.products().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.bss.kotlin.outputs.GetOpenApiProductsProduct.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
