@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cas.kotlin

import com.pulumi.alicloud.cas.CasFunctions.getCertificatesPlain
import com.pulumi.alicloud.cas.CasFunctions.getServiceCertificatesPlain
import com.pulumi.alicloud.cas.kotlin.inputs.GetCertificatesPlainArgs
import com.pulumi.alicloud.cas.kotlin.inputs.GetCertificatesPlainArgsBuilder
import com.pulumi.alicloud.cas.kotlin.inputs.GetServiceCertificatesPlainArgs
import com.pulumi.alicloud.cas.kotlin.inputs.GetServiceCertificatesPlainArgsBuilder
import com.pulumi.alicloud.cas.kotlin.outputs.GetCertificatesResult
import com.pulumi.alicloud.cas.kotlin.outputs.GetServiceCertificatesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cas.kotlin.outputs.GetCertificatesResult.Companion.toKotlin as getCertificatesResultToKotlin
import com.pulumi.alicloud.cas.kotlin.outputs.GetServiceCertificatesResult.Companion.toKotlin as getServiceCertificatesResultToKotlin

public object CasFunctions {
    /**
     * > **DEPRECATED:**  This datasource has been deprecated from version `1.129.0`. Please use new datasource alicloud_ssl_certificates_service_certificates.
     * This data source provides a list of CAS Certificates in an Alibaba Cloud account according to the specified filters.
     * @param argument A collection of arguments for invoking getCertificates.
     * @return A collection of values returned by getCertificates.
     */
    @Deprecated(
        message = """
  This resource has been deprecated in favour of getServiceCertificates
  """,
    )
    public suspend fun getCertificates(argument: GetCertificatesPlainArgs): GetCertificatesResult =
        getCertificatesResultToKotlin(getCertificatesPlain(argument.toJava()).await())

    /**
     * @see [getCertificates].
     * @param enableDetails
     * @param ids A list of cert IDs.
     * @param lang
     * @param nameRegex A regex string to filter results by the certificate name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getCertificates.
     */
    @Deprecated(
        message = """
  This resource has been deprecated in favour of getServiceCertificates
  """,
    )
    public suspend fun getCertificates(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        lang: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetCertificatesResult {
        val argument = GetCertificatesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            lang = lang,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getCertificatesResultToKotlin(getCertificatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cas&#46;kotlin&#46;inputs&#46;GetCertificatesPlainArgs].
     * @return A collection of values returned by getCertificates.
     */
    @Deprecated(
        message = """
  This resource has been deprecated in favour of getServiceCertificates
  """,
    )
    public suspend fun getCertificates(argument: suspend GetCertificatesPlainArgsBuilder.() -> Unit): GetCertificatesResult {
        val builder = GetCertificatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificatesResultToKotlin(getCertificatesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Ssl Certificates Service Certificates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.129.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const certs = alicloud.cas.getCertificates({
     *     nameRegex: "^cas",
     *     ids: ["Certificate Id"],
     * });
     * export const cert = certs.then(certs => certs.certificates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * certs = alicloud.cas.get_certificates(name_regex="^cas",
     *     ids=["Certificate Id"])
     * pulumi.export("cert", certs.certificates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var certs = AliCloud.Cas.GetCertificates.Invoke(new()
     *     {
     *         NameRegex = "^cas",
     *         Ids = new[]
     *         {
     *             "Certificate Id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cert"] = certs&#46;Apply(getCertificatesResult => getCertificatesResult&#46;Certificates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cas"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		certs, err := cas.GetCertificates(ctx, &cas.GetCertificatesArgs{
     * 			NameRegex: pulumi.StringRef("^cas"),
     * 			Ids: []string{
     * 				"Certificate Id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cert", certs.Certificates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cas.CasFunctions;
     * import com.pulumi.alicloud.cas.inputs.GetCertificatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var certs = CasFunctions.getCertificates(GetCertificatesArgs.builder()
     *             .nameRegex("^cas")
     *             .ids("Certificate Id")
     *             .build());
     *         ctx.export("cert", certs.applyValue(getCertificatesResult -> getCertificatesResult.certificates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   certs:
     *     fn::invoke:
     *       Function: alicloud:cas:getCertificates
     *       Arguments:
     *         nameRegex: ^cas
     *         ids:
     *           - Certificate Id
     * outputs:
     *   cert: ${certs.certificates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServiceCertificates.
     * @return A collection of values returned by getServiceCertificates.
     */
    public suspend fun getServiceCertificates(argument: GetServiceCertificatesPlainArgs): GetServiceCertificatesResult =
        getServiceCertificatesResultToKotlin(getServiceCertificatesPlain(argument.toJava()).await())

    /**
     * @see [getServiceCertificates].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Certificate IDs.
     * @param lang The lang.
     * @param nameRegex A regex string to filter results by Certificate name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getServiceCertificates.
     */
    public suspend fun getServiceCertificates(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        lang: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetServiceCertificatesResult {
        val argument = GetServiceCertificatesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            lang = lang,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getServiceCertificatesResultToKotlin(getServiceCertificatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceCertificates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cas&#46;kotlin&#46;inputs&#46;GetServiceCertificatesPlainArgs].
     * @return A collection of values returned by getServiceCertificates.
     */
    public suspend fun getServiceCertificates(argument: suspend GetServiceCertificatesPlainArgsBuilder.() -> Unit): GetServiceCertificatesResult {
        val builder = GetServiceCertificatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceCertificatesResultToKotlin(getServiceCertificatesPlain(builtArgument.toJava()).await())
    }
}
