@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cas.kotlin

import com.pulumi.alicloud.cas.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:**  This datasource has been deprecated from version `1.129.0`. Please use new datasource alicloud_ssl_certificates_service_certificate.
 * Provides a CAS Certificate resource.
 * > **NOTE:** The Certificate name which you want to add must be already registered and had not added by another account. Every Certificate name can only exist in a unique group.
 * > **NOTE:** The Cas Certificate region only support cn-hangzhou, me-east-1, eu-central-1, ap-northeast-1.
 * > **NOTE:** Available in 1.35.0+ .
 * @property cert Cert of the Certificate in which the Certificate will add.
 * @property certificateName
 * @property key Key of the Certificate in which the Certificate will add.
 * @property lang
 * @property name Name of the Certificate. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 */
public data class CertificateArgs
@Deprecated(
    message = """
This resource has been deprecated in favour of ServiceCertificate
""",
)
constructor(
    public val cert: Output<String>? = null,
    public val certificateName: Output<String>? = null,
    public val key: Output<String>? = null,
    public val lang: Output<String>? = null,
    @Deprecated(
        message = """
  attribute 'name' has been deprecated from provider version 1.129.0 and it will be remove in the
      future version. Please use the new attribute 'certificate_name' instead.
  """,
    )
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cas.CertificateArgs> {
    override fun toJava(): com.pulumi.alicloud.cas.CertificateArgs =
        com.pulumi.alicloud.cas.CertificateArgs.builder()
            .cert(cert?.applyValue({ args0 -> args0 }))
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
@Deprecated(
    message = """
This resource has been deprecated in favour of ServiceCertificate
""",
)
public class CertificateArgsBuilder internal constructor() {
    private var cert: Output<String>? = null

    private var certificateName: Output<String>? = null

    private var key: Output<String>? = null

    private var lang: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Cert of the Certificate in which the Certificate will add.
     */
    @JvmName("rreqphbelqdxmaoo")
    public suspend fun cert(`value`: Output<String>) {
        this.cert = value
    }

    /**
     * @param value
     */
    @JvmName("ceanqurrnxveuavu")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Key of the Certificate in which the Certificate will add.
     */
    @JvmName("nncsbcfhfijmpjlb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value
     */
    @JvmName("davqefyycmmgpqyn")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value Name of the Certificate. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @Deprecated(
        message = """
  attribute 'name' has been deprecated from provider version 1.129.0 and it will be remove in the
      future version. Please use the new attribute 'certificate_name' instead.
  """,
    )
    @JvmName("iwhgdedipxxbarjc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Cert of the Certificate in which the Certificate will add.
     */
    @JvmName("nbpfdodjabcrlhdy")
    public suspend fun cert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cert = mapped
    }

    /**
     * @param value
     */
    @JvmName("rqiuqsedmtqxxxyx")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Key of the Certificate in which the Certificate will add.
     */
    @JvmName("rmrehrkkjbnwupru")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("ucbsiyemjptgcmid")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value Name of the Certificate. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @Deprecated(
        message = """
  attribute 'name' has been deprecated from provider version 1.129.0 and it will be remove in the
      future version. Please use the new attribute 'certificate_name' instead.
  """,
    )
    @JvmName("sgwcvnddbpwtygrd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        cert = cert,
        certificateName = certificateName,
        key = key,
        lang = lang,
        name = name,
    )
}
