@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cas.kotlin.inputs

import com.pulumi.alicloud.cas.inputs.GetCertificatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCertificates.
 * @property enableDetails
 * @property ids A list of cert IDs.
 * @property lang
 * @property nameRegex A regex string to filter results by the certificate name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetCertificatesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cas.inputs.GetCertificatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cas.inputs.GetCertificatesPlainArgs =
        com.pulumi.alicloud.cas.inputs.GetCertificatesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificatesPlainArgs].
 */
@PulumiTagMarker
public class GetCertificatesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var lang: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("fhhuroqracntrawv")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of cert IDs.
     */
    @JvmName("ewxvuhirwualkekn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of cert IDs.
     */
    @JvmName("qgmajxtdryusjhte")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("qsjjleqgnssfjcjj")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value A regex string to filter results by the certificate name.
     */
    @JvmName("jexbvrjtierbpgpv")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("snyjhormytruvvup")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetCertificatesPlainArgs = GetCertificatesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        lang = lang,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
